/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.codeInsight.lookup.RealLookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupCellRenderer
implements ListCellRenderer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupCellRenderer");
    private static final int AFTER_TAIL = 10;
    private static final int AFTER_TYPE = 6;
    private Icon myEmptyIcon = EmptyIcon.create((int)5);
    private final Font myNormalFont;
    private final Font myBoldFont;
    private final FontMetrics myNormalMetrics;
    private final FontMetrics myBoldMetrics;
    public static final Color BACKGROUND_COLOR = new JBColor(new Color(235, 244, 254), JBColor.background());
    private static final Color FOREGROUND_COLOR = JBColor.foreground();
    private static final Color GRAYED_FOREGROUND_COLOR = new JBColor((Color)Gray._160, (Color)Gray._110);
    private static final Color SELECTED_BACKGROUND_COLOR = new Color(0, 82, 164);
    private static final Color SELECTED_NON_FOCUSED_BACKGROUND_COLOR = new JBColor(new Color(110, 142, 162), new Color(85, 88, 90));
    private static final Color SELECTED_FOREGROUND_COLOR = new JBColor((Color)JBColor.WHITE, JBColor.foreground());
    private static final Color SELECTED_GRAYED_FOREGROUND_COLOR = new JBColor((Color)JBColor.WHITE, JBColor.foreground());
    static final Color PREFIX_FOREGROUND_COLOR = new JBColor(new Color(176, 0, 176), new Color(209, 122, 214));
    private static final Color SELECTED_PREFIX_FOREGROUND_COLOR = new JBColor(new Color(249, 236, 204), new Color(209, 122, 214));
    private final LookupImpl myLookup;
    private final SimpleColoredComponent myNameComponent;
    private final SimpleColoredComponent myTailComponent;
    private final SimpleColoredComponent myTypeLabel;
    private final LookupPanel myPanel;
    private final Map<Integer, Boolean> mySelected = new HashMap<Integer, Boolean>();
    private static final String ELLIPSIS = "\u2026";
    private int myMaxWidth = -1;
    private boolean myIsSelected = false;

    public LookupCellRenderer(LookupImpl lookup) {
        EditorColorsScheme scheme = lookup.getTopLevelEditor().getColorsScheme();
        this.myNormalFont = scheme.getFont(EditorFontType.PLAIN);
        this.myBoldFont = scheme.getFont(EditorFontType.BOLD);
        this.myLookup = lookup;
        this.myNameComponent = new MySimpleColoredComponent();
        this.myNameComponent.setIpad((Insets)JBUI.insetsLeft((int)2));
        this.myNameComponent.setMyBorder(null);
        this.myTailComponent = new MySimpleColoredComponent();
        this.myTailComponent.setIpad(new Insets(0, 0, 0, 0));
        this.myTypeLabel = new MySimpleColoredComponent();
        this.myTypeLabel.setIpad(new Insets(0, 0, 0, 0));
        this.myPanel = new LookupPanel();
        this.myPanel.add((Component)this.myNameComponent, "West");
        this.myPanel.add((Component)this.myTailComponent, "Center");
        this.myTailComponent.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        this.myPanel.add((Component)this.myTypeLabel, "East");
        this.myTypeLabel.setBorder((Border)new EmptyBorder(0, 0, 0, 6));
        this.myNormalMetrics = this.myLookup.getTopLevelEditor().getComponent().getFontMetrics(this.myNormalFont);
        this.myBoldMetrics = this.myLookup.getTopLevelEditor().getComponent().getFontMetrics(this.myBoldFont);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        boolean useBoxLayout;
        boolean nonFocusedSelection;
        boolean bl = nonFocusedSelection = isSelected && this.myLookup.getFocusDegree() == LookupImpl.FocusDegree.SEMI_FOCUSED;
        if (!this.myLookup.isFocused()) {
            isSelected = false;
        }
        this.myIsSelected = isSelected;
        LookupElement item = (LookupElement)value;
        Color foreground = LookupCellRenderer.getForegroundColor(isSelected);
        Color background = nonFocusedSelection ? SELECTED_NON_FOCUSED_BACKGROUND_COLOR : (isSelected ? SELECTED_BACKGROUND_COLOR : BACKGROUND_COLOR);
        int allowedWidth = list.getWidth() - 10 - 6 - this.getTextIndent();
        FontMetrics normalMetrics = this.getRealFontMetrics(item, false);
        FontMetrics boldMetrics = this.getRealFontMetrics(item, true);
        RealLookupElementPresentation presentation = new RealLookupElementPresentation(isSelected ? this.getMaxWidth() : allowedWidth, normalMetrics, boldMetrics, (Lookup)this.myLookup);
        AccessToken token = ReadAction.start();
        try {
            if (item.isValid()) {
                try {
                    item.renderElement((LookupElementPresentation)presentation);
                }
                catch (ProcessCanceledException e) {
                    LOG.info((Throwable)e);
                    presentation.setItemTextForeground((Color)JBColor.RED);
                    presentation.setItemText("Error occurred, see the log in Help | Show Log");
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                catch (Error e) {
                    LOG.error((Throwable)e);
                }
            } else {
                presentation.setItemTextForeground((Color)JBColor.RED);
                presentation.setItemText("Invalid");
            }
        }
        finally {
            token.finish();
        }
        this.myNameComponent.clear();
        this.myNameComponent.setBackground(background);
        allowedWidth -= this.setItemTextLabel(item, (Color)new JBColor(isSelected ? SELECTED_FOREGROUND_COLOR : presentation.getItemTextForeground(), presentation.getItemTextForeground()), isSelected, (LookupElementPresentation)presentation, allowedWidth);
        Font font = this.myLookup.getCustomFont(item, false);
        if (font == null) {
            font = this.myNormalFont;
        }
        this.myTailComponent.setFont(font);
        this.myTypeLabel.setFont(font);
        this.myNameComponent.setIcon(LookupCellRenderer.augmentIcon(this.myLookup.getEditor(), presentation.getIcon(), this.myEmptyIcon));
        this.myTypeLabel.clear();
        if (allowedWidth > 0) {
            allowedWidth -= this.setTypeTextLabel(item, background, foreground, (LookupElementPresentation)presentation, isSelected ? this.getMaxWidth() : allowedWidth, isSelected, nonFocusedSelection, normalMetrics);
        }
        this.myTailComponent.clear();
        this.myTailComponent.setBackground(background);
        if (isSelected || allowedWidth >= 0) {
            this.setTailTextLabel(isSelected, (LookupElementPresentation)presentation, foreground, isSelected ? this.getMaxWidth() : allowedWidth, nonFocusedSelection, normalMetrics);
        }
        if (this.mySelected.containsKey(index) && !isSelected && this.mySelected.get(index).booleanValue()) {
            this.myPanel.setUpdateExtender(true);
        }
        this.mySelected.put(index, isSelected);
        double w = this.myNameComponent.getPreferredSize().getWidth() + this.myTailComponent.getPreferredSize().getWidth() + this.myTypeLabel.getPreferredSize().getWidth();
        boolean bl2 = useBoxLayout = isSelected && w > (double)list.getWidth() && ((JBList)list).getExpandableItemsHandler().isEnabled();
        if (useBoxLayout != this.myPanel.getLayout() instanceof BoxLayout) {
            this.myPanel.removeAll();
            if (useBoxLayout) {
                this.myPanel.setLayout(new BoxLayout(this.myPanel, 0));
                this.myPanel.add((Component)this.myNameComponent);
                this.myPanel.add((Component)this.myTailComponent);
                this.myPanel.add((Component)this.myTypeLabel);
            } else {
                this.myPanel.setLayout(new BorderLayout());
                this.myPanel.add((Component)this.myNameComponent, "West");
                this.myPanel.add((Component)this.myTailComponent, "Center");
                this.myPanel.add((Component)this.myTypeLabel, "East");
            }
        }
        AccessibleContextUtil.setCombinedName((Component)this.myPanel, (Component)this.myNameComponent, (String)"", (Component)this.myTailComponent, (String)" - ", (Component)this.myTypeLabel);
        AccessibleContextUtil.setCombinedDescription((Component)this.myPanel, (Component)this.myNameComponent, (String)"", (Component)this.myTailComponent, (String)" - ", (Component)this.myTypeLabel);
        return this.myPanel;
    }

    private static Color getForegroundColor(boolean isSelected) {
        return isSelected ? SELECTED_FOREGROUND_COLOR : FOREGROUND_COLOR;
    }

    private int getMaxWidth() {
        if (this.myMaxWidth < 0) {
            Point p = this.myLookup.getComponent().getLocationOnScreen();
            Rectangle rectangle = ScreenUtil.getScreenRectangle((Point)p);
            this.myMaxWidth = rectangle.x + rectangle.width - p.x - 111;
        }
        return this.myMaxWidth;
    }

    private void setTailTextLabel(boolean isSelected, LookupElementPresentation presentation, Color foreground, int allowedWidth, boolean nonFocusedSelection, FontMetrics fontMetrics) {
        int style = LookupCellRenderer.getStyle(false, presentation.isStrikeout(), false);
        for (LookupElementPresentation.TextFragment fragment : presentation.getTailFragments()) {
            if (allowedWidth < 0) {
                return;
            }
            String trimmed = this.trimLabelText(fragment.text, allowedWidth, fontMetrics);
            this.myTailComponent.append(trimmed, new SimpleTextAttributes(style, LookupCellRenderer.getTailTextColor(isSelected, fragment, foreground, nonFocusedSelection)));
            allowedWidth -= RealLookupElementPresentation.getStringWidth((String)trimmed, (FontMetrics)fontMetrics);
        }
    }

    private String trimLabelText(@Nullable String text, int maxWidth, FontMetrics metrics) {
        if (text == null || StringUtil.isEmpty((String)text)) {
            return "";
        }
        int strWidth = RealLookupElementPresentation.getStringWidth((String)text, (FontMetrics)metrics);
        if (strWidth <= maxWidth || this.myIsSelected) {
            return text;
        }
        if (RealLookupElementPresentation.getStringWidth((String)ELLIPSIS, (FontMetrics)metrics) > maxWidth) {
            return "";
        }
        int i = 0;
        int j = text.length();
        while (i + 1 < j) {
            int mid = (i + j) / 2;
            String candidate = text.substring(0, mid) + ELLIPSIS;
            int width = RealLookupElementPresentation.getStringWidth((String)candidate, (FontMetrics)metrics);
            if (width <= maxWidth) {
                i = mid;
                continue;
            }
            j = mid;
        }
        return text.substring(0, i) + ELLIPSIS;
    }

    private static Color getTypeTextColor(LookupElement item, Color foreground, LookupElementPresentation presentation, boolean selected, boolean nonFocusedSelection) {
        if (nonFocusedSelection) {
            return foreground;
        }
        return presentation.isTypeGrayed() ? LookupCellRenderer.getGrayedForeground(selected) : (item instanceof EmptyLookupItem ? JBColor.foreground() : foreground);
    }

    private static Color getTailTextColor(boolean isSelected, LookupElementPresentation.TextFragment fragment, Color defaultForeground, boolean nonFocusedSelection) {
        Color tailForeground;
        if (nonFocusedSelection) {
            return defaultForeground;
        }
        if (fragment.isGrayed()) {
            return LookupCellRenderer.getGrayedForeground(isSelected);
        }
        if (!isSelected && (tailForeground = fragment.getForegroundColor()) != null) {
            return tailForeground;
        }
        return defaultForeground;
    }

    public static Color getGrayedForeground(boolean isSelected) {
        return isSelected ? SELECTED_GRAYED_FOREGROUND_COLOR : GRAYED_FOREGROUND_COLOR;
    }

    private int setItemTextLabel(LookupElement item, Color foreground, boolean selected, LookupElementPresentation presentation, int allowedWidth) {
        boolean bold = presentation.isItemTextBold();
        Font customItemFont = this.myLookup.getCustomFont(item, bold);
        this.myNameComponent.setFont(customItemFont != null ? customItemFont : (bold ? this.myBoldFont : this.myNormalFont));
        int style = LookupCellRenderer.getStyle(bold, presentation.isStrikeout(), presentation.isItemTextUnderlined());
        FontMetrics metrics = this.getRealFontMetrics(item, bold);
        String name = this.trimLabelText(presentation.getItemText(), allowedWidth, metrics);
        int used = RealLookupElementPresentation.getStringWidth((String)name, (FontMetrics)metrics);
        this.renderItemName(item, foreground, selected, style, name, this.myNameComponent);
        return used;
    }

    private FontMetrics getRealFontMetrics(LookupElement item, boolean bold) {
        Font customFont = this.myLookup.getCustomFont(item, bold);
        if (customFont != null) {
            return this.myLookup.getTopLevelEditor().getComponent().getFontMetrics(customFont);
        }
        return bold ? this.myBoldMetrics : this.myNormalMetrics;
    }

    @SimpleTextAttributes.StyleAttributeConstant
    private static int getStyle(boolean bold, boolean strikeout, boolean underlined) {
        int style;
        int n = style = bold ? 1 : 0;
        if (strikeout) {
            style |= 4;
        }
        if (underlined) {
            style |= 0x10;
        }
        return style;
    }

    private void renderItemName(LookupElement item, Color foreground, boolean selected, @SimpleTextAttributes.StyleAttributeConstant int style, String name, SimpleColoredComponent nameComponent) {
        FList<TextRange> ranges;
        String prefix;
        SimpleTextAttributes base = new SimpleTextAttributes(style, foreground);
        String string = prefix = item instanceof EmptyLookupItem ? "" : this.myLookup.itemPattern(item);
        if (prefix.length() > 0 && (ranges = LookupCellRenderer.getMatchingFragments(prefix, name)) != null) {
            SimpleTextAttributes highlighted = new SimpleTextAttributes(style, selected ? SELECTED_PREFIX_FOREGROUND_COLOR : PREFIX_FOREGROUND_COLOR);
            SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)nameComponent, (String)name, ranges, (SimpleTextAttributes)base, (SimpleTextAttributes)highlighted);
            return;
        }
        nameComponent.append(name, base);
    }

    public static FList<TextRange> getMatchingFragments(String prefix, String name) {
        return new MinusculeMatcher("*" + prefix, NameUtil.MatchingCaseSensitivity.NONE).matchingFragments(name);
    }

    private int setTypeTextLabel(LookupElement item, Color background, Color foreground, LookupElementPresentation presentation, int allowedWidth, boolean selected, boolean nonFocusedSelection, FontMetrics normalMetrics) {
        Object o;
        String givenText = presentation.getTypeText();
        String labelText = this.trimLabelText(StringUtil.isEmpty((String)givenText) ? "" : " " + givenText, allowedWidth, normalMetrics);
        int used = RealLookupElementPresentation.getStringWidth((String)labelText, (FontMetrics)normalMetrics);
        Icon icon = presentation.getTypeIcon();
        if (icon != null) {
            this.myTypeLabel.setIcon(icon);
            used += icon.getIconWidth();
        }
        Color sampleBackground = background;
        Object object = o = item.isValid() ? item.getObject() : null;
        if (o instanceof LookupValueWithUIHint && StringUtil.isEmpty((String)labelText)) {
            Color proposedBackground = ((LookupValueWithUIHint)o).getColorHint();
            if (proposedBackground != null) {
                sampleBackground = proposedBackground;
            }
            this.myTypeLabel.append("  ");
            used += normalMetrics.stringWidth("WW");
        } else {
            this.myTypeLabel.append(labelText);
        }
        this.myTypeLabel.setBackground(sampleBackground);
        this.myTypeLabel.setForeground(LookupCellRenderer.getTypeTextColor(item, foreground, presentation, selected, nonFocusedSelection));
        return used;
    }

    public static Icon augmentIcon(@Nullable Editor editor, @Nullable Icon icon, @NotNull Icon standard) {
        if (Registry.is((String)"editor.scale.completion.icons")) {
            standard = EditorUtil.scaleIconAccordingEditorFont(standard, editor);
            icon = EditorUtil.scaleIconAccordingEditorFont(icon, editor);
        }
        if (icon == null) {
            return standard;
        }
        if (icon.getIconHeight() < standard.getIconHeight() || icon.getIconWidth() < standard.getIconWidth()) {
            LayeredIcon layeredIcon = new LayeredIcon(2);
            layeredIcon.setIcon(icon, 0, 0, (standard.getIconHeight() - icon.getIconHeight()) / 2);
            layeredIcon.setIcon(standard, 1);
            return layeredIcon;
        }
        return icon;
    }

    @Nullable
    Font getFontAbleToDisplay(LookupElementPresentation p) {
        String sampleString = p.getItemText() + p.getTailText() + p.getTypeText();
        HashSet fonts = ContainerUtil.newHashSet();
        for (int i = 0; i < sampleString.length(); ++i) {
            fonts.add(EditorUtil.fontForChar(sampleString.charAt(i), 0, this.myLookup.getTopLevelEditor()).getFont());
        }
        block1: for (Font font : fonts) {
            if (font.equals(this.myNormalFont)) continue;
            for (int i = 0; i < sampleString.length(); ++i) {
                if (!font.canDisplay(sampleString.charAt(i))) continue block1;
            }
            return font;
        }
        return null;
    }

    int updateMaximumWidth(LookupElementPresentation p, LookupElement item) {
        Icon icon = p.getIcon();
        if (icon != null && (icon.getIconWidth() > this.myEmptyIcon.getIconWidth() || icon.getIconHeight() > this.myEmptyIcon.getIconHeight())) {
            this.myEmptyIcon = new EmptyIcon(Math.max(icon.getIconWidth(), this.myEmptyIcon.getIconWidth()), Math.max(icon.getIconHeight(), this.myEmptyIcon.getIconHeight()));
        }
        return RealLookupElementPresentation.calculateWidth((LookupElementPresentation)p, (FontMetrics)this.getRealFontMetrics(item, false), (FontMetrics)this.getRealFontMetrics(item, true)) + 10 + 6;
    }

    public int getTextIndent() {
        return this.myNameComponent.getIpad().left + this.myEmptyIcon.getIconWidth() + this.myNameComponent.getIconTextGap();
    }

    private class LookupPanel
    extends JPanel {
        boolean myUpdateExtender;

        public LookupPanel() {
            super(new BorderLayout());
        }

        public void setUpdateExtender(boolean updateExtender) {
            this.myUpdateExtender = updateExtender;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!LookupCellRenderer.this.myLookup.isFocused() && LookupCellRenderer.this.myLookup.isCompletion()) {
                g = g.create();
                try {
                    g.setColor(ColorUtil.withAlpha((Color)BACKGROUND_COLOR, (double)0.4));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                finally {
                    g.dispose();
                }
            }
        }
    }

    private static class MySimpleColoredComponent
    extends SimpleColoredComponent {
        private MySimpleColoredComponent() {
            this.setFocusBorderAroundIcon(true);
        }

        protected void applyAdditionalHints(@NotNull Graphics2D g) {
            super.applyAdditionalHints(g);
        }
    }
}

