/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

class PackageLookupItem
extends LookupElement {
    private final PsiPackage myPackage;
    private final String myString;

    public PackageLookupItem(PsiPackage pkg) {
        this.myPackage = pkg;
        this.myString = StringUtil.notNullize((String)this.myPackage.getName());
    }

    @NotNull
    public Object getObject() {
        return this.myPackage;
    }

    @NotNull
    public String getLookupString() {
        return this.myString;
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
    }

    public void handleInsert(InsertionContext context) {
        boolean addDot;
        PsiFile file2 = context.getFile();
        boolean bl = addDot = !(file2 instanceof PsiJavaCodeReferenceCodeFragment) || ((PsiJavaCodeReferenceCodeFragment)file2).isClassesAccepted();
        if (addDot) {
            context.setAddCompletionChar(false);
            TailType.DOT.processTail(context.getEditor(), context.getTailOffset());
        }
        if (addDot || context.getCompletionChar() == '.') {
            AutoPopupController.getInstance(context.getProject()).scheduleAutoPopup(context.getEditor());
        }
    }
}

