/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupManager {
    @NonNls
    public static final String PROP_ACTIVE_LOOKUP = "activeLookup";

    public static LookupManager getInstance(@NotNull Project project2) {
        return (LookupManager)ServiceManager.getService((Project)project2, LookupManager.class);
    }

    @Nullable
    public static LookupEx getActiveLookup(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project2 = editor.getProject();
        if (project2 == null || project2.isDisposed()) {
            return null;
        }
        LookupEx lookup = LookupManager.getInstance(project2).getActiveLookup();
        if (lookup == null) {
            return null;
        }
        return lookup.getTopLevelEditor() == InjectedLanguageUtil.getTopLevelEditor(editor) ? lookup : null;
    }

    @Nullable
    public LookupEx showLookup(@NotNull Editor editor, LookupElement ... items) {
        return this.showLookup(editor, items, "", new LookupArranger.DefaultArranger());
    }

    @Nullable
    public LookupEx showLookup(@NotNull Editor editor, @NotNull LookupElement[] items, @NotNull String prefix) {
        return this.showLookup(editor, items, prefix, new LookupArranger.DefaultArranger());
    }

    @Nullable
    public abstract LookupEx showLookup(@NotNull Editor var1, @NotNull LookupElement[] var2, @NotNull String var3, @NotNull LookupArranger var4);

    public abstract void hideActiveLookup();

    @Nullable
    public abstract LookupEx getActiveLookup();

    public abstract void addPropertyChangeListener(@NotNull PropertyChangeListener var1);

    public abstract void addPropertyChangeListener(@NotNull PropertyChangeListener var1, @NotNull Disposable var2);

    public abstract void removePropertyChangeListener(@NotNull PropertyChangeListener var1);

    @NotNull
    public abstract Lookup createLookup(@NotNull Editor var1, @NotNull LookupElement[] var2, @NotNull String var3, @NotNull LookupArranger var4);
}

