/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionLookupItem
extends LookupElement
implements TypedLookupItem {
    private final PsiExpression myExpression;
    private final Icon myIcon;
    private final String myPresentableText;
    private final String myLookupString;
    private final Set<String> myAllLookupStrings;

    public ExpressionLookupItem(PsiExpression expression) {
        this(expression, ExpressionLookupItem.getExpressionIcon(expression), expression.getText(), expression.getText());
    }

    public ExpressionLookupItem(PsiExpression expression, @Nullable Icon icon, String presentableText, String ... lookupStrings) {
        this.myExpression = expression;
        this.myPresentableText = presentableText;
        this.myIcon = icon;
        this.myLookupString = lookupStrings[0];
        this.myAllLookupStrings = Collections.unmodifiableSet(ContainerUtil.newHashSet((Object[])lookupStrings));
    }

    @Nullable
    private static Icon getExpressionIcon(@NotNull PsiExpression expression) {
        PsiElement element;
        if (expression instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)expression).resolve()) != null) {
            return element.getIcon(0);
        }
        if (expression instanceof PsiMethodCallExpression) {
            return PlatformIcons.METHOD_ICON;
        }
        return null;
    }

    @NotNull
    public PsiExpression getObject() {
        return this.myExpression;
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setIcon(this.myIcon);
        presentation.setItemText(this.myPresentableText);
        PsiType type = this.getType();
        presentation.setTypeText(type == null ? null : type.getPresentableText());
    }

    @Override
    public PsiType getType() {
        return this.myExpression.getType();
    }

    public boolean equals(Object o) {
        return o instanceof ExpressionLookupItem && this.myLookupString.equals(((ExpressionLookupItem)o).myLookupString);
    }

    public int hashCode() {
        return this.myLookupString.hashCode();
    }

    @NotNull
    public String getLookupString() {
        return this.myLookupString;
    }

    public Set<String> getAllLookupStrings() {
        return this.myAllLookupStrings;
    }
}

