/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.IncreaseLanguageLevelFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionFromFieldInitializerToConstructorThrowsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodBodyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodQualifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMissingRequiredAnnotationParametersFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddNewArrayExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddVariableInitializerFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeClassSignatureFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeExtendsToImplementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeMethodSignatureFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeMethodSignatureFromUsageReverseOrderFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeParameterClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeToAppendFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertSwitchToIfIntention;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertToStringLiteralAction;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateAbstractMethodFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateAnnotationMethodFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromSuperFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromThisFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorMatchingSuperFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorParameterFromFieldFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateGetterOrSetterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateGetterSetterPropertyFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromMethodReferenceFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreatePropertyFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeferFinalAssignmentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteMethodBodyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteMultiCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.EnableOptimizeImportsOnTheFlyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GeneralizeCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ImplementAbstractClassMethodsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ImplementMethodsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InitializeFinalFieldInConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InsertNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InsertSuperFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MakeClassInterfaceFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MakeVarargParameterLastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodParameterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ModifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveBoundClassToFrontFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveCatchUpFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToSeparateFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.NegationBroadScopeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OptimizeImportsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.PullAsAbstractUpFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveNewQualifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveParameterListFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveQualifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedParameterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameToIgnoredFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameWrongRefFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceAddAllArrayToCollectionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceInaccessibleFieldWithGetterSetterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplacePrimitiveWithBoxedTypeAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceWithListAccessFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReuseVariableDeclarationFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SafeDeleteFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SetupJDKFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ShowModulePropertiesFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SuperMethodReturnFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithArrayFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithQuotesAnnotationParameterValueFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithTryCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableAccessFromInnerClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFromCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapLongWithMathToIntExactFix;
import com.intellij.codeInsight.daemon.quickFix.CreateClassOrPackageFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFieldOrPropertyFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.unusedParameters.UnusedParametersInspection;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.refactoring.changeSignature.ChangeSignatureGestureDetector;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickFixFactoryImpl
extends QuickFixFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.QuickFixFactoryImpl");

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createModifierListFix(@NotNull PsiModifierList modifierList, @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        return new ModifierFix(modifierList, modifier, shouldHave, showContainingClass);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createModifierListFix(@NotNull PsiModifierListOwner owner, @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        return new ModifierFix(owner, modifier, shouldHave, showContainingClass);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMethodReturnFix(@NotNull PsiMethod method, @NotNull PsiType toReturn, boolean fixWholeHierarchy) {
        return new MethodReturnTypeFix(method, toReturn, fixWholeHierarchy);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createAddMethodFix(@NotNull PsiMethod method, @NotNull PsiClass toClass) {
        return new AddMethodFix(method, toClass);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createAddMethodFix(@NotNull String methodText, @NotNull PsiClass toClass, String ... exceptions) {
        return new AddMethodFix(methodText, toClass, exceptions);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createImplementMethodsFix(@NotNull PsiClass aClass) {
        return new ImplementMethodsFix((PsiElement)aClass);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createImplementMethodsFix(@NotNull PsiElement psiElement) {
        return new ImplementMethodsFix(psiElement);
    }

    @NotNull
    public LocalQuickFixOnPsiElement createMethodThrowsFix(@NotNull PsiMethod method, @NotNull PsiClassType exceptionClass, boolean shouldThrow, boolean showContainingClass) {
        return new MethodThrowsFix(method, exceptionClass, shouldThrow, showContainingClass);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createAddDefaultConstructorFix(@NotNull PsiClass aClass) {
        return new AddDefaultConstructorFix(aClass);
    }

    public LocalQuickFixAndIntentionActionOnPsiElement createAddConstructorFix(@NotNull PsiClass aClass, @NotNull String modifier) {
        return aClass.getName() != null ? new AddDefaultConstructorFix(aClass, modifier) : null;
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMethodParameterTypeFix(@NotNull PsiMethod method, int index, @NotNull PsiType newType, boolean fixWholeHierarchy) {
        return new MethodParameterFix(method, newType, index, fixWholeHierarchy);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMakeClassInterfaceFix(@NotNull PsiClass aClass) {
        return new MakeClassInterfaceFix(aClass, true);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMakeClassInterfaceFix(@NotNull PsiClass aClass, boolean makeInterface) {
        return new MakeClassInterfaceFix(aClass, makeInterface);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createExtendsListFix(@NotNull PsiClass aClass, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        return new ExtendsListFix(aClass, typeToExtendFrom, toAdd);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createRemoveUnusedParameterFix(@NotNull PsiParameter parameter) {
        return new RemoveUnusedParameterFix(parameter);
    }

    @NotNull
    public IntentionAction createRemoveUnusedVariableFix(@NotNull PsiVariable variable) {
        return new RemoveUnusedVariableFix(variable);
    }

    @Nullable
    public IntentionAction createCreateClassOrPackageFix(@NotNull PsiElement context, @NotNull String qualifiedName, boolean createClass, String superClass) {
        return CreateClassOrPackageFix.createFix(qualifiedName, context, (ClassKind)(createClass ? ClassKind.CLASS : null), superClass);
    }

    @Nullable
    public IntentionAction createCreateClassOrInterfaceFix(@NotNull PsiElement context, @NotNull String qualifiedName, boolean createClass, String superClass) {
        return CreateClassOrPackageFix.createFix(qualifiedName, context, createClass ? ClassKind.CLASS : ClassKind.INTERFACE, superClass);
    }

    @NotNull
    public IntentionAction createCreateFieldOrPropertyFix(@NotNull PsiClass aClass, @NotNull String name, @NotNull PsiType type, @NotNull PropertyMemberType targetMember, PsiAnnotation ... annotations) {
        return new CreateFieldOrPropertyFix(aClass, name, type, targetMember, annotations);
    }

    @NotNull
    public IntentionAction createSetupJDKFix() {
        return SetupJDKFix.getInstance();
    }

    @NotNull
    public IntentionAction createAddExceptionToCatchFix() {
        return new AddExceptionToCatchFix();
    }

    @NotNull
    public IntentionAction createAddExceptionToThrowsFix(@NotNull PsiElement element) {
        return new AddExceptionToThrowsFix(element);
    }

    @NotNull
    public IntentionAction createAddExceptionFromFieldInitializerToConstructorThrowsFix(@NotNull PsiElement element) {
        return new AddExceptionFromFieldInitializerToConstructorThrowsFix(element);
    }

    @NotNull
    public IntentionAction createSurroundWithTryCatchFix(@NotNull PsiElement element) {
        return new SurroundWithTryCatchFix(element);
    }

    @NotNull
    public IntentionAction createGeneralizeCatchFix(@NotNull PsiElement element, @NotNull PsiClassType type) {
        return new GeneralizeCatchFix(element, type);
    }

    @NotNull
    public IntentionAction createChangeToAppendFix(@NotNull IElementType sign, @NotNull PsiType type, @NotNull PsiAssignmentExpression assignment) {
        return new ChangeToAppendFix(sign, type, assignment);
    }

    @NotNull
    public IntentionAction createAddTypeCastFix(@NotNull PsiType type, @NotNull PsiExpression expression) {
        return new AddTypeCastFix(type, expression);
    }

    @NotNull
    public IntentionAction createWrapExpressionFix(@NotNull PsiType type, @NotNull PsiExpression expression) {
        return new WrapExpressionFix(type, expression);
    }

    @NotNull
    public IntentionAction createReuseVariableDeclarationFix(@NotNull PsiLocalVariable variable) {
        return new ReuseVariableDeclarationFix(variable);
    }

    @NotNull
    public IntentionAction createConvertToStringLiteralAction() {
        return new ConvertToStringLiteralAction();
    }

    @NotNull
    public IntentionAction createDeleteCatchFix(@NotNull PsiParameter parameter) {
        return new DeleteCatchFix(parameter);
    }

    @NotNull
    public IntentionAction createDeleteMultiCatchFix(@NotNull PsiTypeElement element) {
        return new DeleteMultiCatchFix(element);
    }

    @NotNull
    public IntentionAction createConvertSwitchToIfIntention(@NotNull PsiSwitchStatement statement2) {
        return new ConvertSwitchToIfIntention(statement2);
    }

    @NotNull
    public IntentionAction createNegationBroadScopeFix(@NotNull PsiPrefixExpression expr) {
        return new NegationBroadScopeFix(expr);
    }

    @NotNull
    public IntentionAction createCreateFieldFromUsageFix(@NotNull PsiReferenceExpression place) {
        return new CreateFieldFromUsageFix(place);
    }

    @NotNull
    public IntentionAction createReplaceWithListAccessFix(@NotNull PsiArrayAccessExpression expression) {
        return new ReplaceWithListAccessFix(expression);
    }

    @NotNull
    public IntentionAction createAddNewArrayExpressionFix(@NotNull PsiArrayInitializerExpression expression) {
        return new AddNewArrayExpressionFix(expression);
    }

    @NotNull
    public IntentionAction createMoveCatchUpFix(@NotNull PsiCatchSection section, @NotNull PsiCatchSection section1) {
        return new MoveCatchUpFix(section, section1);
    }

    @NotNull
    public IntentionAction createRenameWrongRefFix(@NotNull PsiReferenceExpression ref) {
        return new RenameWrongRefFix(ref);
    }

    @NotNull
    public IntentionAction createRemoveQualifierFix(@NotNull PsiExpression qualifier, @NotNull PsiReferenceExpression expression, @NotNull PsiClass resolved) {
        return new RemoveQualifierFix(qualifier, expression, resolved);
    }

    @NotNull
    public IntentionAction createRemoveParameterListFix(@NotNull PsiMethod parent) {
        return new RemoveParameterListFix(parent);
    }

    @NotNull
    public IntentionAndQuickFixAction createShowModulePropertiesFix(@NotNull PsiElement element) {
        return new ShowModulePropertiesFix(element);
    }

    @NotNull
    public IntentionAndQuickFixAction createShowModulePropertiesFix(@NotNull Module module2) {
        return new ShowModulePropertiesFix(module2);
    }

    @NotNull
    public IntentionAction createIncreaseLanguageLevelFix(@NotNull LanguageLevel level) {
        return new IncreaseLanguageLevelFix(level);
    }

    @NotNull
    public IntentionAction createChangeParameterClassFix(@NotNull PsiClass aClass, @NotNull PsiClassType type) {
        return new ChangeParameterClassFix(aClass, type);
    }

    @NotNull
    public IntentionAction createReplaceInaccessibleFieldWithGetterSetterFix(@NotNull PsiElement element, @NotNull PsiMethod getter, boolean isSetter) {
        return new ReplaceInaccessibleFieldWithGetterSetterFix(element, getter, isSetter);
    }

    @NotNull
    public IntentionAction createSurroundWithArrayFix(@Nullable PsiCall methodCall, @Nullable PsiExpression expression) {
        return new SurroundWithArrayFix(methodCall, expression);
    }

    @NotNull
    public IntentionAction createImplementAbstractClassMethodsFix(@NotNull PsiElement elementToHighlight) {
        return new ImplementAbstractClassMethodsFix(elementToHighlight);
    }

    @NotNull
    public IntentionAction createMoveClassToSeparateFileFix(@NotNull PsiClass aClass) {
        return new MoveClassToSeparateFileFix(aClass);
    }

    @NotNull
    public IntentionAction createRenameFileFix(@NotNull String newName) {
        return new RenameFileFix(newName);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createRenameElementFix(@NotNull PsiNamedElement element) {
        return new RenameElementFix(element);
    }

    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createRenameElementFix(@NotNull PsiNamedElement element, @NotNull String newName) {
        return new RenameElementFix(element, newName);
    }

    @NotNull
    public IntentionAction createChangeExtendsToImplementsFix(@NotNull PsiClass aClass, @NotNull PsiClassType classToExtendFrom) {
        return new ChangeExtendsToImplementsFix(aClass, classToExtendFrom);
    }

    @NotNull
    public IntentionAction createCreateConstructorMatchingSuperFix(@NotNull PsiClass aClass) {
        return new CreateConstructorMatchingSuperFix(aClass);
    }

    @NotNull
    public IntentionAction createRemoveNewQualifierFix(@NotNull PsiNewExpression expression, PsiClass aClass) {
        return new RemoveNewQualifierFix(expression, aClass);
    }

    @NotNull
    public IntentionAction createSuperMethodReturnFix(@NotNull PsiMethod superMethod, @NotNull PsiType superMethodType) {
        return new SuperMethodReturnFix(superMethod, superMethodType);
    }

    @NotNull
    public IntentionAction createInsertNewFix(@NotNull PsiMethodCallExpression call, @NotNull PsiClass aClass) {
        return new InsertNewFix(call, aClass);
    }

    @NotNull
    public IntentionAction createAddMethodBodyFix(@NotNull PsiMethod method) {
        return new AddMethodBodyFix(method);
    }

    @NotNull
    public IntentionAction createDeleteMethodBodyFix(@NotNull PsiMethod method) {
        return new DeleteMethodBodyFix(method);
    }

    @NotNull
    public IntentionAction createInsertSuperFix(@NotNull PsiMethod constructor) {
        return new InsertSuperFix(constructor);
    }

    @NotNull
    public IntentionAction createChangeMethodSignatureFromUsageFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] expressions, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        return new ChangeMethodSignatureFromUsageFix(targetMethod, expressions, substitutor, context, changeAllUsages, minUsagesNumberToShowDialog);
    }

    @NotNull
    public IntentionAction createChangeMethodSignatureFromUsageReverseOrderFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] expressions, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        return new ChangeMethodSignatureFromUsageReverseOrderFix(targetMethod, expressions, substitutor, context, changeAllUsages, minUsagesNumberToShowDialog);
    }

    @NotNull
    public IntentionAction createCreateMethodFromUsageFix(@NotNull PsiMethodCallExpression call) {
        return new CreateMethodFromUsageFix(call);
    }

    @NotNull
    public IntentionAction createCreateMethodFromUsageFix(PsiMethodReferenceExpression methodReferenceExpression) {
        return new CreateMethodFromMethodReferenceFix(methodReferenceExpression);
    }

    @NotNull
    public IntentionAction createCreateAbstractMethodFromUsageFix(@NotNull PsiMethodCallExpression call) {
        return new CreateAbstractMethodFromUsageFix(call);
    }

    @NotNull
    public IntentionAction createCreatePropertyFromUsageFix(@NotNull PsiMethodCallExpression call) {
        return new CreatePropertyFromUsageFix(call);
    }

    @NotNull
    public IntentionAction createCreateConstructorFromSuperFix(@NotNull PsiMethodCallExpression call) {
        return new CreateConstructorFromSuperFix(call);
    }

    @NotNull
    public IntentionAction createCreateConstructorFromThisFix(@NotNull PsiMethodCallExpression call) {
        return new CreateConstructorFromThisFix(call);
    }

    @NotNull
    public IntentionAction createCreateGetterSetterPropertyFromUsageFix(@NotNull PsiMethodCallExpression call) {
        return new CreateGetterSetterPropertyFromUsageFix(call);
    }

    @NotNull
    public IntentionAction createStaticImportMethodFix(@NotNull PsiMethodCallExpression call) {
        return new StaticImportMethodFix(call);
    }

    @NotNull
    public IntentionAction createReplaceAddAllArrayToCollectionFix(@NotNull PsiMethodCallExpression call) {
        return new ReplaceAddAllArrayToCollectionFix(call);
    }

    @NotNull
    public IntentionAction createCreateConstructorFromCallFix(@NotNull PsiConstructorCall call) {
        return new CreateConstructorFromCallFix(call);
    }

    @NotNull
    public List<IntentionAction> getVariableTypeFromCallFixes(@NotNull PsiMethodCallExpression call, @NotNull PsiExpressionList list) {
        return VariableTypeFromCallFix.getQuickFixActions(call, list);
    }

    @NotNull
    public IntentionAction createAddReturnFix(@NotNull PsiMethod method) {
        return new AddReturnFix(method);
    }

    @NotNull
    public IntentionAction createAddVariableInitializerFix(@NotNull PsiVariable variable) {
        return new AddVariableInitializerFix(variable);
    }

    @NotNull
    public IntentionAction createDeferFinalAssignmentFix(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression) {
        return new DeferFinalAssignmentFix(variable, expression);
    }

    @NotNull
    public IntentionAction createVariableAccessFromInnerClassFix(@NotNull PsiVariable variable, @NotNull PsiElement scope) {
        return new VariableAccessFromInnerClassFix(variable, scope);
    }

    @NotNull
    public IntentionAction createCreateConstructorParameterFromFieldFix(@NotNull PsiField field) {
        return new CreateConstructorParameterFromFieldFix(field);
    }

    @NotNull
    public IntentionAction createInitializeFinalFieldInConstructorFix(@NotNull PsiField field) {
        return new InitializeFinalFieldInConstructorFix(field);
    }

    @NotNull
    public IntentionAction createRemoveTypeArgumentsFix(@NotNull PsiElement variable) {
        return new RemoveTypeArgumentsFix(variable);
    }

    @NotNull
    public IntentionAction createChangeClassSignatureFromUsageFix(@NotNull PsiClass owner, @NotNull PsiReferenceParameterList parameterList) {
        return new ChangeClassSignatureFromUsageFix(owner, parameterList);
    }

    @NotNull
    public IntentionAction createReplacePrimitiveWithBoxedTypeAction(@NotNull PsiTypeElement element, @NotNull String typeName, @NotNull String boxedTypeName) {
        return new ReplacePrimitiveWithBoxedTypeAction(element, typeName, boxedTypeName);
    }

    @NotNull
    public IntentionAction createMakeVarargParameterLastFix(@NotNull PsiParameter parameter) {
        return new MakeVarargParameterLastFix(parameter);
    }

    @NotNull
    public IntentionAction createMoveBoundClassToFrontFix(@NotNull PsiClass aClass, @NotNull PsiClassType type) {
        return new MoveBoundClassToFrontFix(aClass, type);
    }

    public void registerPullAsAbstractUpFixes(@NotNull PsiMethod method, @NotNull QuickFixActionRegistrar registrar) {
        PullAsAbstractUpFix.registerQuickFix(method, registrar);
    }

    @NotNull
    public IntentionAction createCreateAnnotationMethodFromUsageFix(@NotNull PsiNameValuePair pair) {
        return new CreateAnnotationMethodFromUsageFix(pair);
    }

    @NotNull
    public IntentionAction createOptimizeImportsFix(final boolean onTheFly) {
        final OptimizeImportsFix fix = new OptimizeImportsFix();
        return new IntentionAction(){

            @NotNull
            public String getText() {
                return fix.getText();
            }

            @NotNull
            public String getFamilyName() {
                return fix.getFamilyName();
            }

            public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
                return (!onTheFly || QuickFixFactoryImpl.timeToOptimizeImports(file2)) && fix.isAvailable(project2, editor, file2);
            }

            public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2) throws IncorrectOperationException {
                QuickFixFactoryImpl.invokeOnTheFlyImportOptimizer(new Runnable(){

                    @Override
                    public void run() {
                        fix.invoke(project2, editor, file2);
                    }
                }, file2);
            }

            public boolean startInWriteAction() {
                return fix.startInWriteAction();
            }
        };
    }

    public void registerFixesForUnusedParameter(@NotNull PsiParameter parameter, @NotNull Object highlightInfo) {
        Project myProject = parameter.getProject();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(myProject).getInspectionProfile();
        UnusedParametersInspection unusedParametersInspection = (UnusedParametersInspection)profile.getUnwrappedTool("UnusedParameters", (PsiElement)parameter);
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || unusedParametersInspection != null);
        ArrayList<IntentionAction> options = new ArrayList<IntentionAction>();
        HighlightDisplayKey myUnusedSymbolKey = HighlightDisplayKey.find((String)"unused");
        options.addAll(IntentionManager.getInstance().getStandardIntentionOptions(myUnusedSymbolKey, (PsiElement)parameter));
        if (unusedParametersInspection != null) {
            SuppressQuickFix[] batchSuppressActions = unusedParametersInspection.getBatchSuppressActions((PsiElement)parameter);
            Collections.addAll(options, SuppressIntentionActionFromFix.convertBatchToSuppressIntentionActions(batchSuppressActions));
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new SafeDeleteFix((PsiElement)parameter), options, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)myUnusedSymbolKey));
    }

    @NotNull
    public IntentionAction createAddToDependencyInjectionAnnotationsFix(@NotNull Project project2, @NotNull String qualifiedName, @NotNull String element) {
        EntryPointsManagerBase entryPointsManager = EntryPointsManagerBase.getInstance(project2);
        return SpecialAnnotationsUtil.createAddToSpecialAnnotationsListIntentionAction(QuickFixBundle.message("fix.unused.symbol.injection.text", element, qualifiedName), QuickFixBundle.message("fix.unused.symbol.injection.family", new Object[0]), (List<String>)entryPointsManager.ADDITIONAL_ANNOTATIONS, qualifiedName);
    }

    @NotNull
    public IntentionAction createCreateGetterOrSetterFix(boolean createGetter, boolean createSetter, @NotNull PsiField field) {
        return new CreateGetterOrSetterFix(createGetter, createSetter, field);
    }

    @NotNull
    public IntentionAction createRenameToIgnoredFix(@NotNull PsiNamedElement namedElement) {
        return new RenameToIgnoredFix(namedElement);
    }

    @NotNull
    public IntentionAction createEnableOptimizeImportsOnTheFlyFix() {
        return new EnableOptimizeImportsOnTheFlyFix();
    }

    @NotNull
    public IntentionAction createSafeDeleteFix(@NotNull PsiElement element) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiClass containingClass = method.getContainingClass();
            if (method.getReturnType() != null || containingClass != null && Comparing.strEqual((String)containingClass.getName(), (String)method.getName())) {
                ChangeSignatureGestureDetector.getInstance(method.getProject()).dismissForElement((PsiElement)method);
            }
        }
        return new SafeDeleteFix(element);
    }

    @Nullable
    public List<LocalQuickFix> registerOrderEntryFixes(@NotNull QuickFixActionRegistrar registrar, @NotNull PsiReference reference) {
        return OrderEntryFix.registerFixes(registrar, reference);
    }

    private static void invokeOnTheFlyImportOptimizer(final @NotNull Runnable runnable2, final @NotNull PsiFile file2) {
        final Project project2 = file2.getProject();
        final Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        if (document == null) {
            return;
        }
        final long stamp = document.getModificationStamp();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String afterText;
                if (project2.isDisposed() || document.getModificationStamp() != stamp) {
                    return;
                }
                UndoManager undoManager = UndoManager.getInstance((Project)project2);
                if (undoManager.isUndoInProgress() || undoManager.isRedoInProgress()) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                String beforeText = file2.getText();
                long oldStamp = document.getModificationStamp();
                DocumentUtil.writeInRunUndoTransparentAction(runnable2);
                if (oldStamp != document.getModificationStamp() && Comparing.strEqual((String)beforeText, (String)(afterText = file2.getText()))) {
                    LOG.error((Object)LogMessageEx.createEvent("Import optimizer  hasn't optimized any imports", file2.getViewProvider().getVirtualFile().getPath(), AttachmentFactory.createAttachment(file2.getViewProvider().getVirtualFile())));
                }
            }
        });
    }

    @NotNull
    public IntentionAction createAddMissingRequiredAnnotationParametersFix(@NotNull PsiAnnotation annotation, @NotNull PsiMethod[] annotationMethods, @NotNull Collection<String> missedElements) {
        return new AddMissingRequiredAnnotationParametersFix(annotation, annotationMethods, missedElements);
    }

    @NotNull
    public IntentionAction createSurroundWithQuotesAnnotationParameterValueFix(@NotNull PsiAnnotationMemberValue value, @NotNull PsiType expectedType) {
        return new SurroundWithQuotesAnnotationParameterValueFix(value, expectedType);
    }

    @NotNull
    public IntentionAction addMethodQualifierFix(@NotNull PsiMethodCallExpression methodCall) {
        return new AddMethodQualifierFix(methodCall);
    }

    @NotNull
    public IntentionAction createWrapLongWithMathToIntExactFix(@Nullable PsiType type, @NotNull PsiExpression expression) {
        return new WrapLongWithMathToIntExactFix(type, expression);
    }

    private static boolean timeToOptimizeImports(@NotNull PsiFile file2) {
        if (!CodeInsightSettings.getInstance().OPTIMIZE_IMPORTS_ON_THE_FLY) {
            return false;
        }
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(file2.getProject());
        if (!codeAnalyzer.isHighlightingAvailable(file2) || !(file2 instanceof PsiJavaFile) || file2 instanceof ServerPageFile) {
            return false;
        }
        if (!codeAnalyzer.isErrorAnalyzingFinished(file2)) {
            return false;
        }
        boolean errors = QuickFixFactoryImpl.containsErrorsPreventingOptimize(file2);
        return !errors && DaemonListeners.canChangeFileSilently((PsiFileSystemItem)file2);
    }

    private static boolean containsErrorsPreventingOptimize(@NotNull PsiFile file2) {
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return true;
        }
        PsiImportList importList = ((PsiJavaFile)file2).getImportList();
        final TextRange importsRange = importList == null ? TextRange.EMPTY_RANGE : importList.getTextRange();
        boolean hasErrorsExceptUnresolvedImports = !DaemonCodeAnalyzerEx.processHighlights(document, file2.getProject(), HighlightSeverity.ERROR, 0, document.getTextLength(), new Processor<HighlightInfo>(){

            public boolean process(HighlightInfo error) {
                int infoEnd;
                int infoStart = error.getActualStartOffset();
                return importsRange.containsRange(infoStart, infoEnd = error.getActualEndOffset()) && error.type.equals(HighlightInfoType.WRONG_REF);
            }
        });
        return hasErrorsExceptUnresolvedImports;
    }
}

