/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SurroundAutoCloseableAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        if (!PsiUtil.getLanguageLevel((PsiElement)element).isAtLeast(LanguageLevel.JDK_1_7)) {
            return false;
        }
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class);
        if (variable == null) {
            return false;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return false;
        }
        PsiElement declaration = variable.getParent();
        if (!(declaration instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiElement codeBlock = declaration.getParent();
        if (!(codeBlock instanceof PsiCodeBlock)) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiType)variable.getType(), (String)"java.lang.AutoCloseable");
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaToken brace;
        PsiCodeBlock tryBlock;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class);
        if (variable == null) {
            return;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return;
        }
        PsiElement declaration = variable.getParent();
        if (!(declaration instanceof PsiDeclarationStatement)) {
            return;
        }
        PsiElement codeBlock = declaration.getParent();
        if (!(codeBlock instanceof PsiCodeBlock)) {
            return;
        }
        LocalSearchScope scope = new LocalSearchScope(codeBlock);
        PsiElement last = null;
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope).findAll()) {
            PsiElement usage = PsiTreeUtil.findPrevParent((PsiElement)codeBlock, (PsiElement)reference.getElement());
            if (last != null && usage.getTextOffset() <= last.getTextOffset()) continue;
            last = usage;
        }
        String text = "try (" + variable.getTypeElement().getText() + " " + variable.getName() + " = " + initializer.getText() + ") {}";
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiTryStatement armStatement = (PsiTryStatement)declaration.replace((PsiElement)factory.createStatementFromText(text, codeBlock));
        List<PsiElement> toFormat = null;
        if (last != null) {
            toFormat = SurroundAutoCloseableAction.moveStatements(last, armStatement);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiElement formattedElement = codeStyleManager.reformat((PsiElement)armStatement);
        if (toFormat != null) {
            for (PsiElement psiElement : toFormat) {
                codeStyleManager.reformat(psiElement);
            }
        }
        if (last == null && (tryBlock = ((PsiTryStatement)formattedElement).getTryBlock()) != null && (brace = tryBlock.getLBrace()) != null) {
            editor.getCaretModel().moveToOffset(brace.getTextOffset() + 1);
        }
    }

    private static List<PsiElement> moveStatements(PsiElement last, PsiTryStatement statement2) {
        PsiCodeBlock tryBlock = statement2.getTryBlock();
        assert (tryBlock != null) : statement2.getText();
        PsiElement parent = statement2.getParent();
        SmartList toFormat = new SmartList();
        PsiElement stopAt = last.getNextSibling();
        PsiElement i = statement2.getNextSibling();
        while (i != null && i != stopAt) {
            PsiElement child = i;
            i = PsiTreeUtil.skipSiblingsForward((PsiElement)i, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            if (!(child instanceof PsiDeclarationStatement)) continue;
            PsiElement anchor = child;
            for (PsiElement declared : ((PsiDeclarationStatement)child).getDeclaredElements()) {
                if (!(declared instanceof PsiLocalVariable)) continue;
                final int endOffset = last.getTextRange().getEndOffset();
                boolean contained = ReferencesSearch.search((PsiElement)declared, (SearchScope)new LocalSearchScope(parent)).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference ref) {
                        return ref.getElement().getTextOffset() <= endOffset;
                    }
                });
                if (contained) continue;
                PsiLocalVariable var = (PsiLocalVariable)declared;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statement2.getProject());
                String name = var.getName();
                assert (name != null) : child.getText();
                toFormat.add(parent.addBefore((PsiElement)factory.createVariableDeclarationStatement(name, var.getType(), null), (PsiElement)statement2));
                PsiExpression varInit = var.getInitializer();
                if (varInit != null) {
                    String varAssignText = name + " = " + varInit.getText() + ";";
                    anchor = parent.addAfter((PsiElement)factory.createStatementFromText(varAssignText, parent), anchor);
                }
                var.delete();
            }
            if (child != last || child.isValid()) continue;
            last = anchor;
        }
        PsiElement first = statement2.getNextSibling();
        tryBlock.addRangeBefore(first, last, (PsiElement)tryBlock.getRBrace());
        parent.deleteChildRange(first, last);
        return toFormat;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.surround.resource.with.ARM.block", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }
}

