/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SimplifyBooleanExpressionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return SimplifyBooleanExpressionFix.FAMILY_NAME;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiExpression expression = SimplifyBooleanExpressionAction.getExpressionToSimplify(editor, file2);
        return expression != null && SimplifyBooleanExpressionFix.canBeSimplified(expression);
    }

    private static PsiExpression getExpressionToSimplify(Editor editor, PsiFile file2) {
        PsiExpression expression;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiExpression parent = expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class);
        while (parent instanceof PsiExpression && (PsiType.BOOLEAN.equals((Object)parent.getType()) || parent instanceof PsiConditionalExpression)) {
            expression = parent;
            parent = parent.getParent();
        }
        return expression;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiExpression expression = SimplifyBooleanExpressionAction.getExpressionToSimplify(editor, file2);
        SimplifyBooleanExpressionFix.simplifyExpression(expression);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

