/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.annotations.NotNull;

public class RemoveLiteralUnderscoresAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLiteralExpression.class, (boolean)false);
        if (literalExpression == null) {
            return false;
        }
        PsiType type = literalExpression.getType();
        if (!(PsiType.INT.equals((Object)type) || PsiType.LONG.equals((Object)type) || PsiType.FLOAT.equals((Object)type) || PsiType.DOUBLE.equals((Object)type))) {
            return false;
        }
        String text = literalExpression.getText();
        return text != null && text.contains("_");
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLiteralExpression.class, (boolean)false);
        if (literalExpression == null) {
            return;
        }
        String text = literalExpression.getText();
        String converted = LiteralFormatUtil.removeUnderscores(text);
        if (converted.length() == text.length()) {
            return;
        }
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(converted, null);
        literalExpression.replace((PsiElement)replacement);
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.underscores.in.literals.family", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"intention.remove.literal.underscores", (Object[])new Object[0]);
    }
}

