/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.BaseMoveInitializerToMethodAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MoveInitializerToConstructorAction
extends BaseMoveInitializerToMethodAction {
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"intention.move.initializer.to.constructor", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected Collection<String> getUnsuitableModifiers() {
        return Arrays.asList("static");
    }

    @Override
    @NotNull
    protected Collection<PsiMethod> getOrCreateMethods(@NotNull Project project2, @NotNull Editor editor, PsiFile file2, @NotNull PsiClass aClass) {
        List<PsiMethod> constructors = Arrays.asList(aClass.getConstructors());
        if (constructors.isEmpty()) {
            return MoveInitializerToConstructorAction.createConstructor(project2, editor, file2, aClass);
        }
        return MoveInitializerToConstructorAction.removeChainedConstructors(constructors);
    }

    @NotNull
    private static Collection<PsiMethod> removeChainedConstructors(@NotNull Collection<PsiMethod> constructors) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(constructors);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            PsiMethod constructor = (PsiMethod)iterator.next();
            if (JavaHighlightUtil.getChainedConstructors(constructor) == null) continue;
            iterator.remove();
        }
        return result;
    }

    @NotNull
    private static Collection<PsiMethod> createConstructor(@NotNull Project project2, @NotNull Editor editor, PsiFile file2, @NotNull PsiClass aClass) {
        LocalQuickFixAndIntentionActionOnPsiElement addDefaultConstructorFix = QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass);
        int offset = editor.getCaretModel().getOffset();
        addDefaultConstructorFix.invoke(project2, editor, file2);
        editor.getCaretModel().moveToOffset(offset);
        return Arrays.asList(aClass.getConstructors());
    }
}

