/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IntentionActionWithTextCaching
implements Comparable<IntentionActionWithTextCaching>,
PossiblyDumbAware,
ShortcutProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching");
    private final List<IntentionAction> myOptionIntentions = new ArrayList<IntentionAction>();
    private final List<IntentionAction> myOptionErrorFixes = new ArrayList<IntentionAction>();
    private final List<IntentionAction> myOptionInspectionFixes = new ArrayList<IntentionAction>();
    private final String myText;
    private final IntentionAction myAction;
    private final String myDisplayName;
    private final Icon myIcon;

    IntentionActionWithTextCaching(@NotNull IntentionAction action) {
        this(action, action.getText(), null);
    }

    IntentionActionWithTextCaching(@NotNull HighlightInfo.IntentionActionDescriptor action) {
        this(action.getAction(), action.getDisplayName(), action.getIcon());
    }

    private IntentionActionWithTextCaching(@NotNull IntentionAction action, String displayName, @Nullable Icon icon) {
        this.myIcon = icon;
        this.myText = action.getText();
        LOG.assertTrue(this.myText != null, (Object)("action " + action.getClass() + " text returned null"));
        this.myAction = action;
        this.myDisplayName = displayName;
    }

    @NotNull
    String getText() {
        return this.myText;
    }

    void addIntention(@NotNull IntentionAction action) {
        this.myOptionIntentions.add(action);
    }

    void addErrorFix(@NotNull IntentionAction action) {
        this.myOptionErrorFixes.add(action);
    }

    void addInspectionFix(@NotNull IntentionAction action) {
        this.myOptionInspectionFixes.add(action);
    }

    @NotNull
    IntentionAction getAction() {
        return this.myAction;
    }

    @NotNull
    List<IntentionAction> getOptionIntentions() {
        return this.myOptionIntentions;
    }

    @NotNull
    List<IntentionAction> getOptionErrorFixes() {
        return this.myOptionErrorFixes;
    }

    @NotNull
    List<IntentionAction> getOptionInspectionFixes() {
        return this.myOptionInspectionFixes;
    }

    String getToolName() {
        return this.myDisplayName;
    }

    @NotNull
    public String toString() {
        return this.getText();
    }

    @Override
    public int compareTo(@NotNull IntentionActionWithTextCaching other) {
        if (this.myAction instanceof Comparable) {
            return ((Comparable)this.myAction).compareTo(other.getAction());
        }
        if (other.getAction() instanceof Comparable) {
            return ((Comparable)other.getAction()).compareTo(this.myAction);
        }
        return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)other.getText()));
    }

    Icon getIcon() {
        return this.myIcon;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myAction);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.myAction instanceof ShortcutProvider ? ((ShortcutProvider)this.myAction).getShortcut() : null;
    }
}

