/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.ImplementAbstractMethodHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementAbstractMethodAction
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.implement.abstract.method.family", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiMethod method = ImplementAbstractMethodAction.findMethod(file2, offset);
        if (method == null || !method.isValid()) {
            return false;
        }
        this.setText(this.getIntentionName(method));
        if (!method.getManager().isInProject((PsiElement)method)) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (isAbstract || !method.hasModifierProperty("private") && !method.hasModifierProperty("static")) {
            if (!isAbstract && !ImplementAbstractMethodAction.isOnIdentifier(file2, offset)) {
                return false;
            }
            MyElementProcessor processor2 = new MyElementProcessor(method);
            if (containingClass.isEnum()) {
                for (PsiField field : containingClass.getFields()) {
                    if (!(field instanceof PsiEnumConstant)) continue;
                    PsiEnumConstantInitializer initializingClass = ((PsiEnumConstant)field).getInitializingClass();
                    if (initializingClass == null) {
                        processor2.myHasMissingImplementations = true;
                        continue;
                    }
                    if (!processor2.execute((PsiElement)initializingClass)) break;
                }
            }
            ClassInheritorsSearch.search((PsiClass)containingClass, (boolean)false).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2));
            return this.isAvailable(processor2);
        }
        return false;
    }

    private static boolean isOnIdentifier(PsiFile file2, int offset) {
        PsiElement psiElement = file2.findElementAt(offset);
        return psiElement instanceof PsiIdentifier && psiElement.getParent() instanceof PsiMethod;
    }

    protected String getIntentionName(PsiMethod method) {
        return method.hasModifierProperty("abstract") ? CodeInsightBundle.message((String)"intention.implement.abstract.method.text", (Object[])new Object[]{method.getName()}) : CodeInsightBundle.message((String)"intention.override.method.text", (Object[])new Object[]{method.getName()});
    }

    protected boolean isAvailable(MyElementProcessor processor2) {
        return processor2.hasMissingImplementations();
    }

    @Nullable
    static PsiMethod findExistingImplementation(PsiClass aClass, PsiMethod method) {
        PsiMethod[] methods;
        for (PsiMethod candidate : methods = aClass.findMethodsByName(method.getName(), false)) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = candidate.findSuperMethods(false)) {
                if (!superMethod.equals(method)) continue;
                return candidate;
            }
        }
        return null;
    }

    private static PsiMethod findMethod(PsiFile file2, int offset) {
        PsiMethod method = ImplementAbstractMethodAction._findMethod(file2, offset);
        if (method == null) {
            method = ImplementAbstractMethodAction._findMethod(file2, offset - 1);
        }
        return method;
    }

    private static PsiMethod _findMethod(PsiFile file2, int offset) {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), PsiMethod.class);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiMethod method = ImplementAbstractMethodAction.findMethod(file2, editor.getCaretModel().getOffset());
        if (method == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
            return;
        }
        this.invokeHandler(project2, editor, method);
    }

    protected void invokeHandler(Project project2, Editor editor, PsiMethod method) {
        new ImplementAbstractMethodHandler(project2, editor, method).invoke();
    }

    public boolean startInWriteAction() {
        return false;
    }

    static class MyElementProcessor
    implements PsiElementProcessor {
        private boolean myHasMissingImplementations;
        private boolean myHasExistingImplementations;
        private final PsiMethod myMethod;

        MyElementProcessor(PsiMethod method) {
            this.myMethod = method;
        }

        public boolean hasMissingImplementations() {
            return this.myHasMissingImplementations;
        }

        public boolean hasExistingImplementations() {
            return this.myHasExistingImplementations;
        }

        public boolean execute(@NotNull PsiElement element) {
            if (element instanceof PsiClass) {
                PsiClass aClass = (PsiClass)element;
                if (aClass.isInterface()) {
                    return true;
                }
                PsiMethod existingImplementation = ImplementAbstractMethodAction.findExistingImplementation(aClass, this.myMethod);
                if (existingImplementation != null && !existingImplementation.hasModifierProperty("abstract")) {
                    this.myHasExistingImplementations = true;
                } else if (existingImplementation == null) {
                    this.myHasMissingImplementations = true;
                }
                if (this.myHasMissingImplementations && this.myHasExistingImplementations) {
                    return false;
                }
            }
            return true;
        }
    }
}

