/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileLevelIntentionComponent
extends EditorNotificationPanel {
    private final Project myProject;
    private final Color myBackground;

    public FileLevelIntentionComponent(String description, @NotNull HighlightSeverity severity, @Nullable GutterMark gutterMark, final @Nullable List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> intentions, final @NotNull Project project2, final @NotNull PsiFile psiFile, final @NotNull Editor editor) {
        this.myProject = project2;
        this.myBackground = this.getColor(severity);
        ShowIntentionsPass.IntentionsInfo info = new ShowIntentionsPass.IntentionsInfo();
        if (intentions != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> intention : intentions) {
                HighlightInfo.IntentionActionDescriptor descriptor = (HighlightInfo.IntentionActionDescriptor)intention.getFirst();
                info.intentionsToShow.add(descriptor);
                final IntentionAction action = descriptor.getAction();
                if (action instanceof EmptyIntentionAction) continue;
                final String text = action.getText();
                this.createActionLabel(text, new Runnable(){

                    @Override
                    public void run() {
                        PsiDocumentManager.getInstance((Project)FileLevelIntentionComponent.this.myProject).commitAllDocuments();
                        ShowIntentionActionsHandler.chooseActionAndInvoke(psiFile, editor, action, text);
                    }
                });
            }
        }
        this.myLabel.setText(description);
        if (gutterMark != null) {
            this.myLabel.setIcon(gutterMark.getIcon());
        }
        if (intentions != null && !intentions.isEmpty()) {
            this.myGearLabel.setIcon(AllIcons.General.Gear);
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    IntentionListStep step = new IntentionListStep(null, editor, psiFile, project2);
                    HighlightInfo.IntentionActionDescriptor descriptor = (HighlightInfo.IntentionActionDescriptor)((Pair)intentions.get(0)).getFirst();
                    IntentionActionWithTextCaching actionWithTextCaching = step.wrapAction(descriptor, (PsiElement)psiFile, psiFile, editor);
                    if (step.hasSubstep(actionWithTextCaching)) {
                        step = step.getSubStep(actionWithTextCaching, null);
                    }
                    ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
                    Dimension dimension = popup.getContent().getPreferredSize();
                    Point at = new Point(-dimension.width + FileLevelIntentionComponent.this.myGearLabel.getWidth(), FileLevelIntentionComponent.this.getHeight());
                    popup.show(new RelativePoint(e.getComponent(), at));
                    return true;
                }
            }.installOn((Component)this.myGearLabel);
        }
    }

    public Color getBackground() {
        return this.myBackground;
    }

    @NotNull
    private Color getColor(@NotNull HighlightSeverity severity) {
        if (SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(severity, HighlightSeverity.ERROR) >= 0) {
            return LightColors.RED;
        }
        if (SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(severity, HighlightSeverity.WARNING) >= 0) {
            return LightColors.YELLOW;
        }
        return LightColors.GREEN;
    }
}

