/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractIfConditionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        if (ifStatement == null || ifStatement.getCondition() == null) {
            return false;
        }
        PsiExpression condition = ifStatement.getCondition();
        if (condition == null || !(condition instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
        PsiType expressionType = polyadicExpression.getType();
        if (expressionType == null || !PsiType.BOOLEAN.isAssignableFrom(expressionType)) {
            return false;
        }
        IElementType operation = polyadicExpression.getOperationTokenType();
        if (operation != JavaTokenType.OROR && operation != JavaTokenType.ANDAND) {
            return false;
        }
        PsiExpression operand = ExtractIfConditionAction.findOperand(element, polyadicExpression);
        if (operand == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.extract.if.condition.text", (Object[])new Object[]{PsiExpressionTrimRenderer.render((PsiExpression)operand)}));
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        if (ifStatement == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiStatement newIfStatement = ExtractIfConditionAction.create(factory, ifStatement, element);
        if (newIfStatement == null) {
            return;
        }
        ifStatement.replace(codeStyleManager.reformat((PsiElement)newIfStatement));
    }

    @Nullable
    private static PsiStatement create(@NotNull PsiElementFactory factory, @NotNull PsiIfStatement ifStatement, @NotNull PsiElement element) {
        PsiExpression condition = ifStatement.getCondition();
        if (condition == null || !(condition instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
        PsiExpression operand = ExtractIfConditionAction.findOperand(element, polyadicExpression);
        if (operand == null) {
            return null;
        }
        return ExtractIfConditionAction.create(factory, ifStatement.getThenBranch(), ifStatement.getElseBranch(), operand, ExtractIfConditionAction.removeOperand(factory, polyadicExpression, operand), polyadicExpression.getOperationTokenType());
    }

    @NotNull
    private static PsiExpression removeOperand(@NotNull PsiElementFactory factory, @NotNull PsiPolyadicExpression expression, @NotNull PsiExpression operand) {
        StringBuilder sb = new StringBuilder();
        for (PsiExpression e : expression.getOperands()) {
            if (e == operand) continue;
            PsiJavaToken token = expression.getTokenBeforeOperand(e);
            if (token != null && sb.length() != 0) {
                sb.append(token.getText()).append(" ");
            }
            sb.append(e.getText());
        }
        return factory.createExpressionFromText(sb.toString(), (PsiElement)expression);
    }

    @Nullable
    private static PsiStatement create(@NotNull PsiElementFactory factory, @Nullable PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave, @NotNull IElementType operation) {
        if (thenBranch == null) {
            return null;
        }
        if (operation == JavaTokenType.OROR) {
            return ExtractIfConditionAction.createOrOr(factory, thenBranch, elseBranch, extract, leave);
        }
        if (operation == JavaTokenType.ANDAND) {
            return ExtractIfConditionAction.createAndAnd(factory, thenBranch, elseBranch, extract, leave);
        }
        return null;
    }

    @NotNull
    private static PsiStatement createAndAnd(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave) {
        return factory.createStatementFromText(ExtractIfConditionAction.createIfString(extract, ExtractIfConditionAction.createIfString(leave, thenBranch, elseBranch), elseBranch), (PsiElement)thenBranch);
    }

    @NotNull
    private static PsiStatement createOrOr(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave) {
        return factory.createStatementFromText(ExtractIfConditionAction.createIfString(extract, thenBranch, ExtractIfConditionAction.createIfString(leave, thenBranch, elseBranch)), (PsiElement)thenBranch);
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch) {
        return ExtractIfConditionAction.createIfString(condition.getText(), ExtractIfConditionAction.toThenBranchString(thenBranch), ExtractIfConditionAction.toElseBranchString(elseBranch, false));
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition, @NotNull PsiStatement thenBranch, @Nullable String elseBranch) {
        return ExtractIfConditionAction.createIfString(condition.getText(), ExtractIfConditionAction.toThenBranchString(thenBranch), elseBranch);
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition, @NotNull String thenBranch, @Nullable PsiStatement elseBranch) {
        return ExtractIfConditionAction.createIfString(condition.getText(), thenBranch, ExtractIfConditionAction.toElseBranchString(elseBranch, true));
    }

    @NotNull
    private static String createIfString(@NotNull String condition, @NotNull String thenBranch, @Nullable String elseBranch) {
        String elsePart = elseBranch != null ? " else " + elseBranch : "";
        return "if (" + condition + ")\n" + thenBranch + elsePart;
    }

    @NotNull
    private static String toThenBranchString(@NotNull PsiStatement statement2) {
        if (!(statement2 instanceof PsiBlockStatement)) {
            return "{ " + statement2.getText() + " }";
        }
        return statement2.getText();
    }

    @Nullable
    private static String toElseBranchString(@Nullable PsiStatement statement2, boolean skipElse) {
        if (statement2 == null) {
            return null;
        }
        if (statement2 instanceof PsiBlockStatement || skipElse && statement2 instanceof PsiIfStatement) {
            return statement2.getText();
        }
        return "{ " + statement2.getText() + " }";
    }

    @Nullable
    private static PsiExpression findOperand(@NotNull PsiElement e, @NotNull PsiPolyadicExpression expression) {
        TextRange elementTextRange = e.getTextRange();
        for (PsiExpression operand : expression.getOperands()) {
            TextRange operandTextRange = operand.getTextRange();
            if (operandTextRange == null || !operandTextRange.contains(elementTextRange)) continue;
            return operand;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.extract.if.condition.family", (Object[])new Object[0]);
    }
}

