/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertEqualsMethodToStaticIntention
extends BaseElementAtCaretIntentionAction {
    private static final Logger LOG = Logger.getInstance(ConvertEqualsMethodToStaticIntention.class);
    private static final String REPLACE_TEMPLATE = "java.util.Objects.equals(%s, %s)";
    public static final String TEXT = "Convert '.equals()' to 'java.util.Objects.equals()'";

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)element)) {
            return false;
        }
        PsiElement referenceExpression = element.getParent();
        if (!(referenceExpression instanceof PsiReferenceExpression)) {
            return false;
        }
        if (!"equals".equals(((PsiReferenceExpression)referenceExpression).getReferenceName())) {
            return false;
        }
        PsiElement methodCallExpression = referenceExpression.getParent();
        if (!(methodCallExpression instanceof PsiMethodCallExpression)) {
            return false;
        }
        int argumentsCount = ((PsiMethodCallExpression)methodCallExpression).getArgumentList().getExpressions().length;
        if (argumentsCount != 1) {
            return false;
        }
        PsiMethod method = ((PsiMethodCallExpression)methodCallExpression).resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass javaLangObject = JavaPsiFacade.getInstance((Project)project2).findClass("java.lang.Object", element.getResolveScope());
        if (javaLangObject == null) {
            return false;
        }
        if (javaLangObject.isEquivalentTo((PsiElement)method.getContainingClass())) {
            return true;
        }
        PsiMethod[] superMethods = method.findSuperMethods(javaLangObject);
        return superMethods.length == 1;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return;
        }
        PsiElement parent = element.getParent().getParent();
        LOG.assertTrue(parent instanceof PsiMethodCallExpression);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
        PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
        String qualifierText = qualifier == null ? "this" : qualifier.getText();
        PsiExpression parameter = methodCall.getArgumentList().getExpressions()[0];
        String expressionText = String.format(REPLACE_TEMPLATE, qualifierText, parameter.getText());
        methodCall.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(expressionText, null));
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return TEXT;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }
}

