/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseColorIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertColorRepresentationIntentionAction
extends BaseColorIntentionAction {
    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (!super.isAvailable(project2, editor, element)) {
            return false;
        }
        PsiNewExpression expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false);
        if (expression == null) {
            return false;
        }
        PsiExpressionList arguments = expression.getArgumentList();
        if (arguments == null) {
            return false;
        }
        PsiMethod constructor = expression.resolveConstructor();
        if (constructor == null) {
            return false;
        }
        PsiExpressionList newArguments = ConvertColorRepresentationIntentionAction.createNewArguments(JavaPsiFacade.getElementFactory((Project)project2), constructor.getParameterList().getParameters(), arguments.getExpressions());
        if (newArguments == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.convert.color.representation.text", (Object[])new Object[]{newArguments.getText()}));
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiNewExpression expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false);
        if (expression == null) {
            return;
        }
        PsiExpressionList arguments = expression.getArgumentList();
        if (arguments == null) {
            return;
        }
        PsiMethod constructor = expression.resolveConstructor();
        if (constructor == null) {
            return;
        }
        PsiExpressionList newArguments = ConvertColorRepresentationIntentionAction.createNewArguments(JavaPsiFacade.getElementFactory((Project)project2), constructor.getParameterList().getParameters(), arguments.getExpressions());
        if (newArguments == null) {
            return;
        }
        arguments.replace((PsiElement)newArguments);
    }

    @Nullable
    private static PsiExpressionList createNewArguments(@NotNull PsiElementFactory factory, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments) {
        String[] newValues = ConvertColorRepresentationIntentionAction.createArguments(parameters, arguments);
        if (newValues == null) {
            return null;
        }
        PsiExpressionList result = ((PsiNewExpression)factory.createExpressionFromText("new Object()", (PsiElement)parameters[0])).getArgumentList();
        if (result == null) {
            return null;
        }
        for (String value : newValues) {
            result.add((PsiElement)factory.createExpressionFromText(value, (PsiElement)parameters[0]));
        }
        return result;
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments) {
        if (parameters.length != arguments.length) {
            return null;
        }
        switch (parameters.length) {
            default: {
                return null;
            }
            case 1: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0]);
            }
            case 2: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1]);
            }
            case 3: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1], arguments[2]);
            }
            case 4: 
        }
        return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1], arguments[2], arguments[3]);
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rgbExpression) {
        return ConvertColorRepresentationIntentionAction.createArguments(rgbExpression, 3);
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rgbExpression, @NotNull PsiExpression hasAlphaExpression) {
        Boolean hasAlpha = ConvertColorRepresentationIntentionAction.computeBoolean(hasAlphaExpression);
        if (hasAlpha == null) {
            return null;
        }
        return hasAlpha != false ? ConvertColorRepresentationIntentionAction.createArguments(rgbExpression, 4) : ConvertColorRepresentationIntentionAction.createArguments(rgbExpression);
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rExpression, @NotNull PsiExpression gExpression, @NotNull PsiExpression bExpression) {
        String[] stringArray;
        Integer value = ConvertColorRepresentationIntentionAction.createInt(ConvertColorRepresentationIntentionAction.computeInteger(rExpression), ConvertColorRepresentationIntentionAction.computeInteger(gExpression), ConvertColorRepresentationIntentionAction.computeInteger(bExpression));
        if (value != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "0x" + Integer.toHexString(value);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rExpression, @NotNull PsiExpression gExpression, @NotNull PsiExpression bExpression, @NotNull PsiExpression aExpression) {
        Integer value = ConvertColorRepresentationIntentionAction.createInt(ConvertColorRepresentationIntentionAction.computeInteger(rExpression), ConvertColorRepresentationIntentionAction.computeInteger(gExpression), ConvertColorRepresentationIntentionAction.computeInteger(bExpression), ConvertColorRepresentationIntentionAction.computeInteger(aExpression));
        if (value == null) {
            return null;
        }
        return new String[]{"0x" + Integer.toHexString(value), "true"};
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rgbExpression, int parts) {
        Integer rgb = ConvertColorRepresentationIntentionAction.computeInteger(rgbExpression);
        if (rgb == null) {
            return null;
        }
        String[] result = new String[parts];
        for (int i = 0; i < result.length; ++i) {
            result[result.length - i - 1] = String.valueOf(rgb >> i * 8 & 0xFF);
        }
        return result;
    }

    @Nullable
    private static Integer createInt(Integer ... ints) {
        int result = 0;
        for (Integer i : ints) {
            if (i == null) {
                return null;
            }
            result = result << 8 | i & 0xFF;
        }
        return result;
    }

    @Nullable
    public static Integer computeInteger(@NotNull PsiExpression expr) {
        Object result = ConvertColorRepresentationIntentionAction.compute(expr);
        return result instanceof Integer ? (Integer)result : null;
    }

    @Nullable
    public static Boolean computeBoolean(@NotNull PsiExpression expr) {
        Object result = ConvertColorRepresentationIntentionAction.compute(expr);
        return result instanceof Boolean ? (Boolean)result : null;
    }

    @Nullable
    private static Object compute(@NotNull PsiExpression expr) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expr, true);
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.convert.color.representation.family", (Object[])new Object[0]);
    }
}

