/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ConvertAbsolutePathToRelativeIntentionAction
extends BaseIntentionAction {
    protected boolean isConvertToRelative() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        FileReference fileReference;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null || element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiReference reference = file2.findReferenceAt(offset);
        FileReference fileReference2 = fileReference = reference == null ? null : FileReference.findFileReference(reference);
        if (fileReference != null) {
            FileReferenceSet set = fileReference.getFileReferenceSet();
            FileReference lastReference = set.getLastReference();
            return set.couldBeConvertedTo(this.isConvertToRelative()) && lastReference != null && (!this.isConvertToRelative() && !set.isAbsolutePathReference() || this.isConvertToRelative() && set.isAbsolutePathReference()) && lastReference.resolve() != null;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return "Convert " + (this.isConvertToRelative() ? "absolute" : "relative") + " path to " + (this.isConvertToRelative() ? "relative" : "absolute");
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        FileReference lastReference;
        FileReference fileReference;
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiReference reference = file2.findReferenceAt(editor.getCaretModel().getOffset());
        FileReference fileReference2 = fileReference = reference == null ? null : FileReference.findFileReference(reference);
        if (fileReference != null && (lastReference = fileReference.getFileReferenceSet().getLastReference()) != null) {
            lastReference.bindToElement((PsiElement)lastReference.resolve(), !this.isConvertToRelative());
        }
    }

    @NotNull
    public String getText() {
        return "Convert path to " + (this.isConvertToRelative() ? "relative" : "absolute");
    }

    public boolean startInWriteAction() {
        return true;
    }
}

