/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class AddAnnotationIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
    }

    @NotNull
    public abstract Pair<String, String[]> getAnnotations(@NotNull Project var1);

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file2, editor.getCaretModel().getOffset());
        if (owner == null || owner.getManager().isInProject((PsiElement)owner) && !CodeStyleSettingsManager.getSettings((Project)project2).USE_EXTERNAL_ANNOTATIONS) {
            return false;
        }
        Pair<String, String[]> annotations = this.getAnnotations(project2);
        String toAdd = (String)annotations.first;
        String[] toRemove = (String[])annotations.second;
        if (toRemove.length > 0 && AddAnnotationIntention.isAnnotatedSkipInferred(owner, toRemove)) {
            return false;
        }
        this.setText(AddAnnotationPsiFix.calcText(owner, toAdd));
        if (AddAnnotationIntention.isAnnotatedSkipInferred(owner, toAdd)) {
            return false;
        }
        if (owner instanceof PsiMethod) {
            PsiType returnType = ((PsiMethod)owner).getReturnType();
            return returnType != null && !(returnType instanceof PsiPrimitiveType);
        }
        if (owner instanceof PsiClass) {
            return PsiUtil.isLanguageLevel8OrHigher((PsiElement)owner);
        }
        return true;
    }

    private static boolean isAnnotatedSkipInferred(PsiModifierListOwner owner, String ... annoFqns) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)false, (String[])annoFqns);
        return annotation != null && !AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file2, editor.getCaretModel().getOffset());
        if (owner == null || !owner.isValid()) {
            return;
        }
        Pair<String, String[]> annotations = this.getAnnotations(project2);
        String toAdd = (String)annotations.first;
        String[] toRemove = (String[])annotations.second;
        AddAnnotationFix fix = new AddAnnotationFix(toAdd, owner, toRemove);
        fix.invoke(project2, editor, file2);
    }
}

