/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrevNextParameterHandler
extends EditorActionHandler {
    private final boolean myIsNextParameterHandler;

    public PrevNextParameterHandler(boolean isNextParameterHandler) {
        this.myIsNextParameterHandler = isNextParameterHandler;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement exprList = PrevNextParameterHandler.getExpressionList(editor, caret.getOffset(), project2);
        if (exprList == null) {
            return false;
        }
        int lbraceOffset = exprList.getTextRange().getStartOffset();
        return ParameterInfoController.isAlreadyShown(editor, lbraceOffset) && ParameterInfoController.hasPrevOrNextParameter(editor, lbraceOffset, this.myIsNextParameterHandler);
    }

    protected void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        int offset = caret != null ? caret.getOffset() : editor.getCaretModel().getOffset();
        PsiElement exprList = PrevNextParameterHandler.getExpressionList(editor, offset, dataContext);
        if (exprList != null) {
            int listOffset = exprList.getTextRange().getStartOffset();
            ParameterInfoController.prevOrNextParameter(editor, listOffset, this.myIsNextParameterHandler);
        }
    }

    @Nullable
    private static PsiElement getExpressionList(@NotNull Editor editor, int offset, DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project2 != null ? PrevNextParameterHandler.getExpressionList(editor, offset, project2) : null;
    }

    @Nullable
    private static PsiElement getExpressionList(@NotNull Editor editor, int offset, @NotNull Project project2) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        return file2 != null ? (PsiElement)ParameterInfoController.findArgumentList(file2, offset, -1) : null;
    }
}

