/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class InspectionDescriptionLinkHandler
extends TooltipLinkHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.hint.InspectionDescriptionLinkHandler");

    public String getDescription(@NotNull String refSuffix, @NotNull Editor editor) {
        Project project2 = editor.getProject();
        if (project2 == null) {
            LOG.error((Object)editor);
            return null;
        }
        if (project2.isDisposed()) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        InspectionProfile profile = (InspectionProfile)InspectionProfileManager.getInstance().getRootProfile();
        InspectionToolWrapper toolWrapper = profile.getInspectionTool(refSuffix, (PsiElement)file2);
        if (toolWrapper == null) {
            return null;
        }
        String description = toolWrapper.loadDescription();
        if (description == null) {
            LOG.warn("No description for inspection '" + refSuffix + "'");
            description = InspectionsBundle.message((String)"inspection.tool.description.under.construction.text", (Object[])new Object[0]);
        }
        return description;
    }
}

