/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceMatcherTerminationAspect;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PairedBraceMatcherAdapter
implements NontrivialBraceMatcher,
PairedBraceMatcher {
    private final PairedBraceMatcher myMatcher;
    private final Language myLanguage;

    public PairedBraceMatcherAdapter(PairedBraceMatcher matcher, Language language) {
        this.myMatcher = matcher;
        this.myLanguage = language;
    }

    public BracePair[] getPairs() {
        return this.myMatcher.getPairs();
    }

    @Override
    public int getBraceTokenGroupId(IElementType tokenType) {
        BracePair[] pairs;
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair.getLeftBraceType() && tokenType != pair.getRightBraceType()) continue;
            return this.myLanguage.hashCode();
        }
        return -1;
    }

    @Nullable
    public BracePair findPair(boolean left, HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        BracePair[] pairs;
        IElementType tokenType = iterator.getTokenType();
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != (left ? pair.getLeftBraceType() : pair.getRightBraceType())) continue;
            return pair;
        }
        return null;
    }

    @Override
    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        return this.findPair(true, iterator, fileText, fileType) != null;
    }

    @Override
    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        return this.findPair(false, iterator, fileText, fileType) != null;
    }

    @Override
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        BracePair[] pairs;
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (type == pair.getRightBraceType()) {
                return pair.getLeftBraceType();
            }
            if (type != pair.getLeftBraceType()) continue;
            return pair.getRightBraceType();
        }
        return null;
    }

    @Override
    public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
        BracePair[] pairs;
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if ((tokenType != pair.getLeftBraceType() || tokenType2 != pair.getRightBraceType()) && (tokenType != pair.getRightBraceType() || tokenType2 != pair.getLeftBraceType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
        BracePair[] pairs;
        IElementType tokenType = iterator.getTokenType();
        for (BracePair pair : pairs = this.myMatcher.getPairs()) {
            if (tokenType != pair.getRightBraceType() && tokenType != pair.getLeftBraceType()) continue;
            return pair.isStructural();
        }
        return false;
    }

    @Override
    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        return this.myMatcher.isPairedBracesAllowedBeforeType(lbraceType, contextType);
    }

    @Override
    public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
        return this.myMatcher.getCodeConstructStart(file2, openingBraceOffset);
    }

    @Override
    @NotNull
    public List<IElementType> getOppositeBraceTokenTypes(@NotNull IElementType type) {
        List<IElementType> result = null;
        for (BracePair pair : this.myMatcher.getPairs()) {
            IElementType match = null;
            if (type == pair.getRightBraceType()) {
                match = pair.getLeftBraceType();
            }
            if (type == pair.getLeftBraceType()) {
                match = pair.getRightBraceType();
            }
            if (match == null) continue;
            if (result == null) {
                result = new ArrayList<IElementType>(2);
            }
            result.add(match);
        }
        return result != null ? result : Collections.emptyList();
    }

    @Override
    public boolean shouldStopMatch(boolean forward, @NotNull IElementType braceType, @NotNull HighlighterIterator iterator) {
        if (this.myMatcher instanceof BraceMatcherTerminationAspect) {
            return ((BraceMatcherTerminationAspect)this.myMatcher).shouldStopMatch(forward, braceType, iterator);
        }
        return false;
    }
}

