/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightOverridingMethodsHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiReferenceList;
import org.jetbrains.annotations.NotNull;

public class HighlightOverridingMethodsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    @Override
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull PsiElement target) {
        if (target instanceof PsiKeyword && ("extends".equals(target.getText()) || "implements".equals(target.getText()))) {
            PsiElement parent = target.getParent();
            if (!(parent instanceof PsiReferenceList)) {
                return null;
            }
            PsiElement grand = parent.getParent();
            if (!(grand instanceof PsiClass)) {
                return null;
            }
            return new HighlightOverridingMethodsHandler(editor, file2, target, (PsiClass)grand);
        }
        return null;
    }
}

