/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.highlighting.HighlightExceptionsHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightExceptionsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    @Override
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull PsiElement target) {
        if (target instanceof PsiKeyword) {
            PsiElement parent = target.getParent();
            if ("try".equals(target.getText()) && parent instanceof PsiTryStatement) {
                return HighlightExceptionsHandlerFactory.createHighlightTryHandler(editor, file2, target, parent);
            }
            if ("catch".equals(target.getText()) && parent instanceof PsiCatchSection) {
                return HighlightExceptionsHandlerFactory.createHighlightCatchHandler(editor, file2, target, parent);
            }
            if ("throws".equals(target.getText())) {
                return HighlightExceptionsHandlerFactory.createThrowsHandler(editor, file2, target);
            }
        }
        return null;
    }

    @Nullable
    private static HighlightUsagesHandlerBase createHighlightTryHandler(Editor editor, PsiFile file2, PsiElement target, PsiElement parent) {
        PsiTryStatement tryStatement = (PsiTryStatement)parent;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return null;
        }
        Collection<PsiClassType> psiClassTypes = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock);
        return new HighlightExceptionsHandler(editor, file2, target, psiClassTypes.toArray(new PsiClassType[psiClassTypes.size()]), (PsiElement)tryBlock, (Condition<PsiType>)Conditions.alwaysTrue());
    }

    @Nullable
    private static HighlightUsagesHandlerBase createHighlightCatchHandler(Editor editor, PsiFile file2, PsiElement target, PsiElement parent) {
        PsiCatchSection catchSection = (PsiCatchSection)parent;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiTryStatement tryStatement = catchSection.getTryStatement();
        final PsiParameter param = catchSection.getParameter();
        if (param == null) {
            return null;
        }
        final PsiParameter[] catchBlockParameters = tryStatement.getCatchBlockParameters();
        Collection<PsiClassType> allThrownExceptions = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryStatement.getTryBlock(), (PsiElement)tryStatement.getTryBlock());
        Condition<PsiType> filter = new Condition<PsiType>(){

            public boolean value(PsiType type) {
                for (PsiParameter parameter : catchBlockParameters) {
                    boolean isAssignable = parameter.getType().isAssignableFrom(type);
                    if (parameter != param) {
                        if (!isAssignable) continue;
                        return false;
                    }
                    return isAssignable;
                }
                return false;
            }
        };
        ArrayList<PsiClassType> filtered = new ArrayList<PsiClassType>();
        for (PsiClassType type : allThrownExceptions) {
            if (!filter.value((Object)type)) continue;
            filtered.add(type);
        }
        return new HighlightExceptionsHandler(editor, file2, target, filtered.toArray(new PsiClassType[filtered.size()]), (PsiElement)tryStatement.getTryBlock(), filter);
    }

    @Nullable
    private static HighlightUsagesHandlerBase createThrowsHandler(Editor editor, PsiFile file2, PsiElement target) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.throws");
        PsiElement grand = target.getParent().getParent();
        if (!(grand instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)grand;
        if (method.getBody() == null) {
            return null;
        }
        Collection<PsiClassType> psiClassTypes = ExceptionUtil.collectUnhandledExceptions((PsiElement)method.getBody(), (PsiElement)method.getBody());
        return new HighlightExceptionsHandler(editor, file2, target, psiClassTypes.toArray(new PsiClassType[psiClassTypes.size()]), (PsiElement)method.getBody(), (Condition<PsiType>)Conditions.alwaysTrue());
    }
}

