/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.actions.MultiCaretCodeInsightAction;
import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.codeInsight.generation.CommentByBlockCommentHandler;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CommentByBlockCommentAction
extends MultiCaretCodeInsightAction
implements DumbAware {
    public CommentByBlockCommentAction() {
        this.setEnabledInModalContext(true);
    }

    @Override
    @NotNull
    protected MultiCaretCodeInsightActionHandler getHandler() {
        return new CommentByBlockCommentHandler();
    }

    @Override
    protected boolean isValidFor(@NotNull Project project2, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file2) {
        FileType fileType = file2.getFileType();
        if (fileType instanceof AbstractFileType) {
            return ((AbstractFileType)fileType).getCommenter() != null;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file2.getLanguage());
        if (commenter == null) {
            commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file2.getViewProvider().getBaseLanguage());
        }
        if (commenter == null) {
            return false;
        }
        return commenter.getBlockCommentPrefix() != null && commenter.getBlockCommentSuffix() != null;
    }
}

