/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GenerationInfoBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiGenerationInfo<T extends PsiMember>
extends GenerationInfoBase
implements GenerationInfo {
    private T myMember;
    private final boolean myMergeIfExists;
    private static final Logger LOG = Logger.getInstance((String)("#" + PsiGenerationInfo.class.getName()));

    public PsiGenerationInfo(@NotNull T member) {
        this.myMember = member;
        this.myMergeIfExists = true;
    }

    public PsiGenerationInfo(@NotNull T member, boolean mergeIfExists) {
        this.myMember = member;
        this.myMergeIfExists = mergeIfExists;
    }

    public final T getPsiMember() {
        return this.myMember;
    }

    @Override
    public void insert(@NotNull PsiClass aClass, @Nullable PsiElement anchor, boolean before) throws IncorrectOperationException {
        Object existingMember = this.myMember instanceof PsiField ? aClass.findFieldByName(this.myMember.getName(), false) : (this.myMember instanceof PsiMethod ? aClass.findMethodBySignature((PsiMethod)this.myMember, false) : null);
        if (existingMember == null || !this.myMergeIfExists) {
            PsiElement newMember = GenerateMembersUtil.insert(aClass, this.myMember, anchor, before);
            this.myMember = (PsiMember)JavaCodeStyleManager.getInstance((Project)aClass.getProject()).shortenClassReferences(newMember);
            LOG.assertTrue(this.myMember.isValid(), this.myMember);
        } else {
            PsiModifierList modifierList = this.myMember.getModifierList();
            PsiModifierList existingModifierList = existingMember.getModifierList();
            if (modifierList != null && existingModifierList != null) {
                PsiElement annoAnchor;
                PsiAnnotation[] psiAnnotations = modifierList.getAnnotations();
                Object object = annoAnchor = existingModifierList.getAnnotations().length > 0 ? existingModifierList.getAnnotations()[0] : existingModifierList.getFirstChild();
                if (psiAnnotations.length > 0) {
                    for (PsiAnnotation annotation : psiAnnotations) {
                        PsiAnnotation existingAnno = existingModifierList.findAnnotation(annotation.getQualifiedName());
                        if (existingAnno != null) {
                            annoAnchor = existingAnno.replace((PsiElement)annotation);
                            continue;
                        }
                        existingModifierList.addBefore((PsiElement)annotation, annoAnchor);
                    }
                }
            }
            this.myMember = existingMember;
            if (!this.myMember.isValid()) {
                LOG.error("invalid member: " + this.myMember + " existing member: " + existingMember.isValid() + " self modified list: " + modifierList + " existing modified list: " + existingModifierList);
            }
        }
    }
}

