/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OverrideImplementsAnnotationsHandlerImpl
implements OverrideImplementsAnnotationsHandler {
    @Override
    public String[] getAnnotations(Project project2) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        ArrayList<String> anns = new ArrayList<String>(manager.getNotNulls());
        anns.addAll(manager.getNullables());
        anns.add("org.jetbrains.annotations.Nls");
        return ArrayUtil.toStringArray(anns);
    }

    @Override
    @NotNull
    public String[] annotationsToRemove(Project project2, @NotNull String fqName) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        if (manager.getNotNulls().contains(fqName)) {
            return ArrayUtil.toStringArray((Collection)manager.getNullables());
        }
        if (manager.getNullables().contains(fqName)) {
            return ArrayUtil.toStringArray((Collection)manager.getNotNulls());
        }
        if (Comparing.strEqual((String)fqName, (String)"org.jetbrains.annotations.Nls")) {
            return new String[]{"org.jetbrains.annotations.NonNls"};
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }
}

