/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.generation.PsiMethodWithOverridingPercentMember;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverrideImplementMemberChooser
extends MemberChooser<PsiMethodMember> {
    private static final String SORT_METHODS_BY_PERCENT_DESCRIPTION = "Sort by Percent of Classes which Overrides a Method";
    @NonNls
    public static final String PROP_COMBINED_OVERRIDE_IMPLEMENT = "OverrideImplement.combined";
    @NonNls
    public static final String PROP_OVERRIDING_SORTED_OVERRIDE_IMPLEMENT = "OverrideImplement.overriding.sorted";
    private ToggleAction myMergeAction;
    private final PsiMethodMember[] myAllElements;
    private final PsiMethodMember[] myOnlyPrimaryElements;
    private final NotNullLazyValue<PsiMethodWithOverridingPercentMember[]> myLazyElementsWithPercent;
    private final boolean myToImplement;
    private final Project myProject;
    private boolean myMerge;
    private boolean mySortedByOverriding;

    @Nullable
    public static JavaOverrideImplementMemberChooser create(PsiElement aClass, boolean toImplement, final Collection<CandidateInfo> candidates, Collection<CandidateInfo> secondary) {
        Project project2 = aClass.getProject();
        if (candidates.isEmpty() && secondary.isEmpty()) {
            return null;
        }
        ClassMember[] onlyPrimary = JavaOverrideImplementMemberChooser.convertToMethodMembers(candidates);
        LinkedHashSet<CandidateInfo> allCandidates = new LinkedHashSet<CandidateInfo>(candidates);
        allCandidates.addAll(secondary);
        ClassMember[] all = JavaOverrideImplementMemberChooser.convertToMethodMembers(allCandidates);
        NotNullLazyValue<PsiMethodWithOverridingPercentMember[]> lazyElementsWithPercent = new NotNullLazyValue<PsiMethodWithOverridingPercentMember[]>(){

            @NotNull
            protected PsiMethodWithOverridingPercentMember[] compute() {
                PsiMethodWithOverridingPercentMember[] elements = PsiMethodWithOverridingPercentMember.calculateOverridingPercents(candidates);
                Arrays.sort(elements, PsiMethodWithOverridingPercentMember.COMPARATOR);
                return elements;
            }
        };
        boolean merge = PropertiesComponent.getInstance((Project)project2).getBoolean(PROP_COMBINED_OVERRIDE_IMPLEMENT, true);
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)aClass);
        boolean overrideVisible = languageLevel.isAtLeast(LanguageLevel.JDK_1_6) || languageLevel.equals((Object)LanguageLevel.JDK_1_5) && !toImplement;
        JavaOverrideImplementMemberChooser javaOverrideImplementMemberChooser = new JavaOverrideImplementMemberChooser((PsiMethodMember[])all, (PsiMethodMember[])onlyPrimary, lazyElementsWithPercent, project2, overrideVisible, merge, toImplement, PropertiesComponent.getInstance((Project)project2).getBoolean(PROP_OVERRIDING_SORTED_OVERRIDE_IMPLEMENT));
        javaOverrideImplementMemberChooser.setTitle(JavaOverrideImplementMemberChooser.getChooserTitle(toImplement, merge));
        javaOverrideImplementMemberChooser.setCopyJavadocVisible(true);
        if (toImplement) {
            if (onlyPrimary.length == 0) {
                javaOverrideImplementMemberChooser.selectElements(new ClassMember[]{all[0]});
            } else {
                javaOverrideImplementMemberChooser.selectElements(onlyPrimary);
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!toImplement || onlyPrimary.length == 0) {
                javaOverrideImplementMemberChooser.selectElements(all);
            }
            javaOverrideImplementMemberChooser.close(0);
            return javaOverrideImplementMemberChooser;
        }
        return javaOverrideImplementMemberChooser;
    }

    private JavaOverrideImplementMemberChooser(PsiMethodMember[] allElements, PsiMethodMember[] onlyPrimaryElements, NotNullLazyValue<PsiMethodWithOverridingPercentMember[]> lazyElementsWithPercent, @NotNull Project project2, boolean isInsertOverrideVisible, boolean merge, boolean toImplement, boolean sortedByOverriding) {
        super(false, true, project2, isInsertOverrideVisible, null, null);
        this.myAllElements = allElements;
        this.myOnlyPrimaryElements = onlyPrimaryElements;
        this.myLazyElementsWithPercent = lazyElementsWithPercent;
        this.myProject = project2;
        this.myMerge = merge;
        this.myToImplement = toImplement;
        this.mySortedByOverriding = sortedByOverriding;
        this.resetElements(JavaOverrideImplementMemberChooser.getInitialElements(allElements, onlyPrimaryElements, lazyElementsWithPercent, merge, toImplement, sortedByOverriding));
        this.init();
    }

    private static PsiMethodMember[] getInitialElements(PsiMethodMember[] allElements, PsiMethodMember[] onlyPrimaryElements, NotNullLazyValue<PsiMethodWithOverridingPercentMember[]> lazyElementsWithPercent, boolean merge, boolean toImplement, boolean sortByOverriding) {
        boolean showElementsWithPercents = sortByOverriding && !toImplement;
        PsiMethodMember[] defaultElements = toImplement || merge ? allElements : onlyPrimaryElements;
        return showElementsWithPercents ? (PsiMethodMember[])lazyElementsWithPercent.getValue() : defaultElements;
    }

    @Override
    protected void onAlphabeticalSortingEnabled(AnActionEvent event) {
        this.mySortedByOverriding = false;
        this.resetElements(this.myToImplement || this.myMerge ? this.myAllElements : this.myOnlyPrimaryElements, null, true);
        this.restoreTree();
    }

    protected void doOKAction() {
        super.doOKAction();
        PropertiesComponent.getInstance((Project)this.myProject).setValue(PROP_COMBINED_OVERRIDE_IMPLEMENT, this.myMerge, true);
        PropertiesComponent.getInstance((Project)this.myProject).setValue(PROP_OVERRIDING_SORTED_OVERRIDE_IMPLEMENT, this.mySortedByOverriding);
    }

    @Override
    protected void fillToolbarActions(DefaultActionGroup group) {
        super.fillToolbarActions(group);
        if (this.myToImplement) {
            return;
        }
        MySortByOverridingAction sortByOverridingAction = new MySortByOverridingAction();
        if (this.mySortedByOverriding) {
            this.changeSortComparator(PsiMethodWithOverridingPercentMember.COMPARATOR);
        }
        group.add((AnAction)sortByOverridingAction, Constraints.FIRST);
        this.myMergeAction = new MyMergeAction();
        group.add((AnAction)this.myMergeAction);
    }

    private static String getChooserTitle(boolean toImplement, boolean merge) {
        return toImplement ? CodeInsightBundle.message((String)"methods.to.implement.chooser.title", (Object[])new Object[0]) : (merge ? CodeInsightBundle.message((String)"methods.to.override.implement.chooser.title", (Object[])new Object[0]) : CodeInsightBundle.message((String)"methods.to.override.chooser.title", (Object[])new Object[0]));
    }

    private static PsiMethodMember[] convertToMethodMembers(Collection<CandidateInfo> candidates) {
        return (PsiMethodMember[])ContainerUtil.map2Array(candidates, PsiMethodMember.class, (Function)new Function<CandidateInfo, PsiMethodMember>(){

            public PsiMethodMember fun(CandidateInfo s) {
                return new PsiMethodMember(s);
            }
        });
    }

    private class MyMergeAction
    extends ToggleAction {
        private MyMergeAction() {
            super("Show methods to implement", "Show methods to implement", AllIcons.General.Show_to_implement);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(73, 8)), (JComponent)JavaOverrideImplementMemberChooser.this.myTree);
            Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("OverrideMethods");
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)JavaOverrideImplementMemberChooser.this.myTree);
        }

        public boolean isSelected(AnActionEvent e) {
            return JavaOverrideImplementMemberChooser.this.myMerge;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            JavaOverrideImplementMemberChooser.this.myMerge = state;
            if (state && JavaOverrideImplementMemberChooser.this.mySortedByOverriding) {
                JavaOverrideImplementMemberChooser.this.mySortedByOverriding = false;
            }
            JavaOverrideImplementMemberChooser.this.resetElements(state ? JavaOverrideImplementMemberChooser.this.myAllElements : JavaOverrideImplementMemberChooser.this.myOnlyPrimaryElements, null, true);
            JavaOverrideImplementMemberChooser.this.restoreTree();
            JavaOverrideImplementMemberChooser.this.setTitle(JavaOverrideImplementMemberChooser.getChooserTitle(false, JavaOverrideImplementMemberChooser.this.myMerge));
        }
    }

    private class MySortByOverridingAction
    extends ToggleAction {
        public MySortByOverridingAction() {
            super(JavaOverrideImplementMemberChooser.SORT_METHODS_BY_PERCENT_DESCRIPTION, JavaOverrideImplementMemberChooser.SORT_METHODS_BY_PERCENT_DESCRIPTION, AllIcons.ObjectBrowser.SortedByUsage);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(85, 8)), (JComponent)JavaOverrideImplementMemberChooser.this.myTree);
        }

        public boolean isSelected(AnActionEvent e) {
            return JavaOverrideImplementMemberChooser.this.mySortedByOverriding;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            JavaOverrideImplementMemberChooser.this.mySortedByOverriding = state;
            if (state) {
                if (JavaOverrideImplementMemberChooser.this.myMerge) {
                    JavaOverrideImplementMemberChooser.this.myMergeAction.setSelected(e, false);
                }
                JavaOverrideImplementMemberChooser.this.disableAlphabeticalSorting(e);
                ClassMember[] elementsWithPercent = (PsiMethodWithOverridingPercentMember[])JavaOverrideImplementMemberChooser.this.myLazyElementsWithPercent.getValue();
                JavaOverrideImplementMemberChooser.this.resetElements(elementsWithPercent, PsiMethodWithOverridingPercentMember.COMPARATOR, false);
            } else {
                ClassMember[] elementsToRender = JavaOverrideImplementMemberChooser.this.myMerge ? JavaOverrideImplementMemberChooser.this.myAllElements : JavaOverrideImplementMemberChooser.this.myOnlyPrimaryElements;
                JavaOverrideImplementMemberChooser.this.resetElementsWithDefaultComparator(elementsToRender, true);
            }
        }
    }
}

