/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFoldingHandler
extends EditorActionHandler {
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        return editor.getProject() != null;
    }

    protected List<FoldRegion> getFoldRegionsForSelection(@NotNull Editor editor, @Nullable Caret caret) {
        FoldRegion[] allRegions = editor.getFoldingModel().getAllFoldRegions();
        if (caret == null) {
            caret = editor.getCaretModel().getPrimaryCaret();
        }
        if (caret.hasSelection()) {
            ArrayList<FoldRegion> result = new ArrayList<FoldRegion>();
            for (FoldRegion region : allRegions) {
                if (region.getStartOffset() < caret.getSelectionStart() || region.getEndOffset() > caret.getSelectionEnd()) continue;
                result.add(region);
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        return Arrays.asList(allRegions);
    }

    protected List<FoldRegion> getFoldRegionsForCaret(@NotNull Editor editor, @Nullable Caret caret, boolean toCollapse) {
        if (caret == null) {
            caret = editor.getCaretModel().getPrimaryCaret();
        }
        int offset = caret.getOffset();
        FoldRegion rootRegion = FoldingUtil.findFoldRegionStartingAtLine(editor, editor.getDocument().getLineNumber(offset));
        if (rootRegion == null || toCollapse && !rootRegion.isExpanded()) {
            FoldRegion[] regions;
            rootRegion = null;
            for (FoldRegion region : regions = FoldingUtil.getFoldRegionsAtOffset(editor, offset)) {
                if (region.isExpanded() != toCollapse) continue;
                rootRegion = region;
                break;
            }
        }
        ArrayList<FoldRegion> result = new ArrayList<FoldRegion>();
        if (rootRegion != null) {
            FoldRegion[] allRegions;
            for (FoldRegion region : allRegions = editor.getFoldingModel().getAllFoldRegions()) {
                if (region.getStartOffset() < rootRegion.getStartOffset() || region.getEndOffset() > rootRegion.getEndOffset()) continue;
                result.add(region);
            }
        }
        return result;
    }
}

