/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterNameFoldingManager {
    private static final int MIN_NAME_LENGTH_THRESHOLD = 3;
    private static final int MIN_ARGS_TO_FOLD = 2;
    private static final List<Couple<String>> COMMONLY_USED_PARAMETER_PAIR = ContainerUtil.newArrayList((Object[])new Couple[]{Couple.of((Object)"begin", (Object)"end"), Couple.of((Object)"start", (Object)"end"), Couple.of((Object)"first", (Object)"last"), Couple.of((Object)"first", (Object)"second"), Couple.of((Object)"from", (Object)"to"), Couple.of((Object)"key", (Object)"value"), Couple.of((Object)"min", (Object)"max")});
    private final PsiCallExpression myCallExpression;
    private PsiExpression[] myCallArguments;
    private PsiParameter[] myParameters;

    public ParameterNameFoldingManager(@NotNull PsiCallExpression callExpression) {
        this.myCallExpression = callExpression;
    }

    public static boolean isLiteralExpression(@Nullable PsiElement callArgument) {
        if (callArgument instanceof PsiLiteralExpression) {
            return true;
        }
        if (callArgument instanceof PsiPrefixExpression) {
            PsiPrefixExpression expr = (PsiPrefixExpression)callArgument;
            IElementType tokenType = expr.getOperationTokenType();
            return (JavaTokenType.MINUS.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType)) && expr.getOperand() instanceof PsiLiteralExpression;
        }
        return false;
    }

    @Nullable
    public PsiExpression[] getArguments(@NotNull PsiCallExpression call) {
        PsiExpressionList callArgumentsList = call.getArgumentList();
        return callArgumentsList != null ? callArgumentsList.getExpressions() : null;
    }

    @NotNull
    public List<FoldingDescriptor> buildDescriptors() {
        PsiMethod method;
        this.myCallArguments = this.getArguments(this.myCallExpression);
        if (this.myCallArguments != null && this.myCallArguments.length >= 2 && ParameterNameFoldingManager.hasLiteralExpression(this.myCallArguments) && (method = this.myCallExpression.resolveMethod()) != null) {
            this.myParameters = method.getParameterList().getParameters();
            if (this.myParameters.length == this.myCallArguments.length) {
                return this.buildDescriptorsForLiteralArguments();
            }
        }
        return ContainerUtil.emptyList();
    }

    @NotNull
    private List<FoldingDescriptor> buildDescriptorsForLiteralArguments() {
        ArrayList descriptors = ContainerUtil.newArrayList();
        int i = 0;
        while (i < this.myCallArguments.length) {
            if (i + 1 < this.myCallArguments.length && this.isCommonlyNamedParameterPair(i, i + 1)) {
                i += 2;
                continue;
            }
            if (this.shouldInlineParameterName(i)) {
                descriptors.add(ParameterNameFoldingManager.createFoldingDescriptor(this.myCallArguments[i], this.myParameters[i]));
            }
            ++i;
        }
        return descriptors;
    }

    @NotNull
    private static NamedFoldingDescriptor createFoldingDescriptor(@NotNull PsiExpression callArgument, @NotNull PsiParameter methodParam) {
        TextRange range = callArgument.getTextRange();
        String placeholderText = methodParam.getName() + ": " + callArgument.getText();
        return new NamedFoldingDescriptor((PsiElement)callArgument, range.getStartOffset(), range.getEndOffset(), null, placeholderText);
    }

    private boolean isCommonlyNamedParameterPair(int first, int second) {
        assert (first < this.myParameters.length && second < this.myParameters.length);
        String firstParamName = this.myParameters[first].getName();
        String secondParamName = this.myParameters[second].getName();
        if (firstParamName == null || secondParamName == null) {
            return false;
        }
        for (Couple<String> knownPair : COMMONLY_USED_PARAMETER_PAIR) {
            if (!StringUtil.containsIgnoreCase((String)firstParamName, (String)((String)knownPair.first)) || !StringUtil.containsIgnoreCase((String)secondParamName, (String)((String)knownPair.second))) continue;
            return true;
        }
        return false;
    }

    private boolean shouldInlineParameterName(int paramIndex) {
        PsiParameter parameter;
        String paramName;
        PsiExpression argument = this.myCallArguments[paramIndex];
        if (ParameterNameFoldingManager.isLiteralExpression((PsiElement)argument) && argument.getType() != null && (paramName = (parameter = this.myParameters[paramIndex]).getName()) != null && paramName.length() >= 3) {
            return TypeConversionUtil.isAssignable((PsiType)parameter.getType(), (PsiType)argument.getType());
        }
        return false;
    }

    private static boolean hasLiteralExpression(@NotNull PsiExpression[] arguments) {
        for (PsiExpression argument : arguments) {
            if (!ParameterNameFoldingManager.isLiteralExpression((PsiElement)argument)) continue;
            return true;
        }
        return false;
    }
}

