/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.AbstractElementSignatureProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OffsetsElementSignatureProvider
extends AbstractElementSignatureProvider {
    private static final String TYPE_MARKER = "e";

    @Override
    protected PsiElement restoreBySignatureTokens(@NotNull PsiFile file2, @NotNull PsiElement parent, @NotNull String type, @NotNull StringTokenizer tokenizer, @Nullable StringBuilder processingInfoStorage) {
        PsiFile psiFile;
        FileViewProvider viewProvider;
        PsiElement element;
        int end;
        int start;
        if (!TYPE_MARKER.equals(type)) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Stopping '%s' provider because given signature doesn't have expected type - can work with '%s' but got '%s'%n", this.getClass().getName(), TYPE_MARKER, type));
            }
            return null;
        }
        try {
            start = Integer.parseInt(tokenizer.nextToken());
            end = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Parsed target offsets - [%d; %d)%n", start, end));
        }
        int index = 0;
        if (tokenizer.hasMoreTokens()) {
            try {
                index = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Language language = file2.getLanguage();
        if (tokenizer.hasMoreTokens()) {
            String languageId = tokenizer.nextToken();
            Language languageFromSignature = Language.findLanguageByID((String)languageId);
            if (languageFromSignature == null) {
                if (processingInfoStorage != null) {
                    processingInfoStorage.append(String.format("Couldn't find language for id %s", languageId));
                }
            } else {
                language = languageFromSignature;
            }
        }
        if ((element = (viewProvider = file2.getViewProvider()).findElementAt(start, language)) == null) {
            return null;
        }
        PsiElement result = this.findElement(start, end, index, element, processingInfoStorage);
        if (result != null) {
            return result;
        }
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Failed to find an element by the given offsets for language %s. Started by the element '%s' (%s)", language, element, element.getText()));
        }
        if ((psiFile = viewProvider.getPsi(language)) == null) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Couldn't find PSI for language %s", language.toString()));
            }
            return null;
        }
        PsiElement injectedStartElement = InjectedLanguageUtil.findElementAtNoCommit(psiFile, start);
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Trying to find injected element starting from the '%s'%s%n", injectedStartElement, injectedStartElement == null ? "" : String.format("(%s)", injectedStartElement.getText())));
        }
        if (injectedStartElement != null && injectedStartElement != element) {
            return this.findElement(start, end, index, injectedStartElement, processingInfoStorage);
        }
        return null;
    }

    @Nullable
    private PsiElement findElement(int start, int end, int index, @NotNull PsiElement element, @Nullable StringBuilder processingInfoStorage) {
        TextRange range = element.getTextRange();
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Starting processing from element '%s'. It's range is %s%n", element, range));
        }
        while (range != null && range.getStartOffset() == start && range.getEndOffset() < end) {
            element = element.getParent();
            range = element.getTextRange();
            if (processingInfoStorage == null) continue;
            processingInfoStorage.append(String.format("Expanding element to '%s' and range to '%s'%n", element, range));
        }
        if (range == null || range.getStartOffset() != start || range.getEndOffset() != end) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Stopping %s because target element's range differs from the target one. Element: '%s', it's range: %s%n", this.getClass(), element, range));
            }
            return null;
        }
        int indexFromRoot = 0;
        for (PsiElement e = element.getParent(); e != null && range.equals((Object)e.getTextRange()); e = e.getParent()) {
            ++indexFromRoot;
        }
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Target element index is %d. Current index from root is %d%n", index, indexFromRoot));
        }
        if (index > indexFromRoot) {
            int steps = index - indexFromRoot;
            PsiElement result = element;
            for (PsiElement e = result.getFirstChild(); steps > 0 && e != null && range.equals((Object)e.getTextRange()); --steps, e = e.getFirstChild()) {
                if (processingInfoStorage != null) {
                    processingInfoStorage.append(String.format("Clarifying target element to '%s', its range is %s%n", result, result.getTextRange()));
                }
                result = e;
            }
            return result;
        }
        int steps = indexFromRoot - index;
        PsiElement result = element;
        while (--steps >= 0) {
            result = result.getParent();
            if (processingInfoStorage == null) continue;
            processingInfoStorage.append(String.format("Reducing target element to '%s', its range is %s%n", result, result.getTextRange()));
        }
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Returning element '%s', its range is %s%n", result, result.getTextRange()));
        }
        return result;
    }

    @Override
    public String getSignature(@NotNull PsiElement element) {
        TextRange range = element.getTextRange();
        if (range.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(TYPE_MARKER).append("#");
        buffer.append(range.getStartOffset());
        buffer.append("#");
        buffer.append(range.getEndOffset());
        int index = 0;
        for (PsiElement e = element.getParent(); e != null && range.equals((Object)e.getTextRange()); e = e.getParent()) {
            ++index;
        }
        buffer.append("#").append(index);
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null && containingFile.getViewProvider().getLanguages().size() > 1) {
            buffer.append("#").append(containingFile.getLanguage().getID());
        }
        return buffer.toString();
    }
}

