/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFoldingInfo {
    private static final Key<EditorFoldingInfo> KEY = Key.create((String)"EditorFoldingInfo.KEY");
    private final Map<FoldRegion, SmartPsiElementPointer<?>> myFoldRegionToSmartPointerMap = new THashMap();

    @NotNull
    public static EditorFoldingInfo get(@NotNull Editor editor) {
        EditorFoldingInfo info = (EditorFoldingInfo)editor.getUserData(KEY);
        if (info == null) {
            info = new EditorFoldingInfo();
            editor.putUserData(KEY, (Object)info);
        }
        return info;
    }

    @Nullable
    public PsiElement getPsiElement(@NotNull FoldRegion region) {
        SmartPsiElementPointer<?> pointer = this.myFoldRegionToSmartPointerMap.get(region);
        if (pointer == null) {
            return null;
        }
        PsiElement element = pointer.getElement();
        return element != null && element.isValid() ? element : null;
    }

    @Nullable
    public TextRange getPsiElementRange(@NotNull FoldRegion region) {
        PsiElement element = this.getPsiElement(region);
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        boolean isInjected = injectedManager.isInjectedFragment(containingFile);
        TextRange range = element.getTextRange();
        if (isInjected) {
            range = injectedManager.injectedToHost(element, range);
        }
        return range;
    }

    public boolean isLightRegion(@NotNull FoldRegion region) {
        return this.myFoldRegionToSmartPointerMap.get(region) == null;
    }

    public void addRegion(@NotNull FoldRegion region, @NotNull SmartPsiElementPointer<?> pointer) {
        this.myFoldRegionToSmartPointerMap.put(region, pointer);
    }

    public void removeRegion(@NotNull FoldRegion region) {
        this.myFoldRegionToSmartPointerMap.remove(region);
    }

    public void dispose() {
        this.myFoldRegionToSmartPointerMap.clear();
    }
}

