/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CollapseExpandDocCommentsHandler
implements CodeInsightActionHandler {
    private final boolean myExpand;

    public CollapseExpandDocCommentsHandler(boolean isExpand) {
        this.myExpand = isExpand;
    }

    public void invoke(@NotNull Project project2, final @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project2);
        foldingManager.updateFoldRegions(editor);
        final FoldRegion[] allFoldRegions = editor.getFoldingModel().getAllFoldRegions();
        Runnable processor2 = new Runnable(){

            @Override
            public void run() {
                for (FoldRegion region : allFoldRegions) {
                    PsiElement element = EditorFoldingInfo.get(editor).getPsiElement(region);
                    if (!(element instanceof PsiDocCommentBase)) continue;
                    region.setExpanded(CollapseExpandDocCommentsHandler.this.myExpand);
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor2);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

