/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.DocumentFoldingInfo;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.containers.WeakList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFoldingManagerImpl
extends CodeFoldingManager
implements ProjectComponent {
    private final Project myProject;
    private final List<Document> myDocumentsWithFoldingInfo = new WeakList();
    private final Key<DocumentFoldingInfo> myFoldingInfoInDocumentKey = Key.create((String)"FOLDING_INFO_IN_DOCUMENT_KEY");
    private static final Key<Boolean> FOLDING_STATE_KEY = Key.create((String)"FOLDING_STATE_KEY");

    CodeFoldingManagerImpl(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public String getComponentName() {
        return "CodeFoldingManagerImpl";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        for (Document document : this.myDocumentsWithFoldingInfo) {
            if (document == null) continue;
            document.putUserData(this.myFoldingInfoInDocumentKey, null);
        }
    }

    public void projectOpened() {
        final EditorMouseMotionAdapter myMouseMotionListener = new EditorMouseMotionAdapter(){
            LightweightHint myCurrentHint = null;
            FoldRegion myCurrentFold = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseMoved(EditorMouseEvent e) {
                if (CodeFoldingManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                HintManager hintManager = HintManager.getInstance();
                if (hintManager != null && hintManager.hasShownHintsThatWillHideByOtherHint(false)) {
                    return;
                }
                if (e.getArea() != EditorMouseEventArea.FOLDING_OUTLINE_AREA) {
                    return;
                }
                LightweightHint hint = null;
                try {
                    Editor editor = e.getEditor();
                    if (PsiDocumentManager.getInstance((Project)CodeFoldingManagerImpl.this.myProject).isUncommited(editor.getDocument())) {
                        return;
                    }
                    MouseEvent mouseEvent = e.getMouseEvent();
                    FoldRegion fold = ((EditorEx)editor).getGutterComponentEx().findFoldingAnchorAt(mouseEvent.getX(), mouseEvent.getY());
                    if (fold == null || !fold.isValid()) {
                        return;
                    }
                    if (fold == this.myCurrentFold && this.myCurrentHint != null) {
                        hint = this.myCurrentHint;
                        return;
                    }
                    TextRange psiElementRange = EditorFoldingInfo.get(editor).getPsiElementRange(fold);
                    if (psiElementRange == null) {
                        return;
                    }
                    int textOffset = psiElementRange.getStartOffset();
                    Point foldStartXY = editor.visualPositionToXY(editor.offsetToVisualPosition(Math.max(textOffset, fold.getStartOffset())));
                    Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
                    if (visibleArea.y > foldStartXY.y) {
                        int desiredEndVisualLine;
                        int startVisualLine;
                        int endVisualLine;
                        Container contentPane;
                        if (this.myCurrentHint != null) {
                            this.myCurrentHint.hide();
                            this.myCurrentHint = null;
                        }
                        int availableVisualLines = 2;
                        JComponent editorComponent = editor.getComponent();
                        Container editorComponentParent = editorComponent.getParent();
                        if (editorComponentParent != null && (contentPane = editorComponent.getRootPane().getContentPane()) != null) {
                            int y = SwingUtilities.convertPoint((Component)editorComponentParent, (Point)editorComponent.getLocation(), (Component)contentPane).y;
                            int visualLines = y / editor.getLineHeight();
                            availableVisualLines = Math.max(availableVisualLines, visualLines);
                        }
                        if ((endVisualLine = (startVisualLine = editor.offsetToVisualPosition((int)textOffset).line) + availableVisualLines) > (desiredEndVisualLine = Math.max(0, editor.xyToVisualPosition((Point)new Point((int)0, (int)visibleArea.y)).line - 1))) {
                            endVisualLine = desiredEndVisualLine;
                        }
                        int endOffset = editor.logicalPositionToOffset(editor.visualToLogicalPosition(new VisualPosition(endVisualLine, 0)));
                        UnfairTextRange textRange = new UnfairTextRange(textOffset, endOffset);
                        hint = EditorFragmentComponent.showEditorFragmentHint(editor, (TextRange)textRange, true, true);
                        this.myCurrentFold = fold;
                        this.myCurrentHint = hint;
                    }
                }
                finally {
                    if (hint == null) {
                        if (this.myCurrentHint != null) {
                            this.myCurrentHint.hide();
                            this.myCurrentHint = null;
                        }
                        this.myCurrentFold = null;
                    }
                }
            }
        };
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                EditorFactory.getInstance().getEventMulticaster().addEditorMouseMotionListener((EditorMouseMotionListener)myMouseMotionListener, (Disposable)CodeFoldingManagerImpl.this.myProject);
            }
        });
    }

    @Override
    public void releaseFoldings(@NotNull Editor editor) {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
        Project project2 = editor.getProject();
        if (!(project2 == null || project2.equals(this.myProject) && project2.isOpen())) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file2 == null || !file2.getViewProvider().isPhysical() || !file2.isValid()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        Editor[] otherEditors = EditorFactory.getInstance().getEditors(document, this.myProject);
        if (otherEditors.length == 0 && !editor.isDisposed()) {
            this.getDocumentFoldingInfo(document).loadFromEditor(editor);
        }
        EditorFoldingInfo.get(editor).dispose();
    }

    @Override
    public void buildInitialFoldings(@NotNull Editor editor) {
        Project project2 = editor.getProject();
        if (project2 == null || !project2.equals(this.myProject) || editor.isDisposed()) {
            return;
        }
        if (!((FoldingModelEx)editor.getFoldingModel()).isFoldingEnabled()) {
            return;
        }
        if (!FoldingUpdate.supportsDumbModeFolding(editor)) {
            return;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        CodeFoldingState foldingState = this.buildInitialFoldings(document);
        if (foldingState != null) {
            foldingState.setToEditor(editor);
        }
    }

    @Override
    @Nullable
    public CodeFoldingState buildInitialFoldings(@NotNull Document document) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        if (psiDocumentManager.isUncommited(document)) {
            return null;
        }
        final PsiFile file2 = psiDocumentManager.getPsiFile(document);
        if (file2 == null || !file2.isValid() || !file2.getViewProvider().isPhysical() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        final FoldingUpdate.FoldingMap foldingMap = FoldingUpdate.getFoldingsFor(file2, document, true);
        return new CodeFoldingState(){

            @Override
            public void setToEditor(@NotNull Editor editor) {
                ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
                if (CodeFoldingManagerImpl.this.myProject.isDisposed() || editor.isDisposed()) {
                    return;
                }
                FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
                if (!foldingModel.isFoldingEnabled()) {
                    return;
                }
                if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                    return;
                }
                if (DumbService.isDumb((Project)CodeFoldingManagerImpl.this.myProject) && !FoldingUpdate.supportsDumbModeFolding(editor)) {
                    return;
                }
                foldingModel.runBatchFoldingOperationDoNotCollapseCaret(new UpdateFoldRegionsOperation(CodeFoldingManagerImpl.this.myProject, editor, file2, foldingMap, UpdateFoldRegionsOperation.ApplyDefaultStateMode.YES, false, false));
                CodeFoldingManagerImpl.this.initFolding(editor);
            }
        };
    }

    private void initFolding(final @NotNull Editor editor) {
        final Document document = editor.getDocument();
        editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                Editor[] editors;
                DocumentFoldingInfo documentFoldingInfo = CodeFoldingManagerImpl.this.getDocumentFoldingInfo(document);
                for (Editor otherEditor : editors = EditorFactory.getInstance().getEditors(document, CodeFoldingManagerImpl.this.myProject)) {
                    if (otherEditor == editor || !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(otherEditor)) continue;
                    documentFoldingInfo.loadFromEditor(otherEditor);
                    break;
                }
                documentFoldingInfo.setToEditor(editor);
                documentFoldingInfo.clear();
                editor.putUserData(FOLDING_STATE_KEY, (Object)Boolean.TRUE);
            }
        });
    }

    public void projectClosed() {
    }

    @Override
    @Nullable
    public FoldRegion findFoldRegion(@NotNull Editor editor, int startOffset, int endOffset) {
        return FoldingUtil.findFoldRegion(editor, startOffset, endOffset);
    }

    @Override
    public FoldRegion[] getFoldRegionsAtOffset(@NotNull Editor editor, int offset) {
        return FoldingUtil.getFoldRegionsAtOffset(editor, offset);
    }

    @Override
    public void updateFoldRegions(@NotNull Editor editor) {
        this.updateFoldRegions(editor, false);
    }

    public void updateFoldRegions(Editor editor, boolean quick) {
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable2 = this.updateFoldRegions(editor, false, quick);
        if (runnable2 != null) {
            runnable2.run();
        }
    }

    @Override
    public void forceDefaultState(final @NotNull Editor editor) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable2 = this.updateFoldRegions(editor, true, false);
        if (runnable2 != null) {
            runnable2.run();
        }
        final FoldRegion[] regions = editor.getFoldingModel().getAllFoldRegions();
        editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                EditorFoldingInfo foldingInfo = EditorFoldingInfo.get(editor);
                for (FoldRegion region : regions) {
                    PsiElement element = foldingInfo.getPsiElement(region);
                    if (element == null) continue;
                    region.setExpanded(!FoldingPolicy.isCollapseByDefault(element));
                }
            }
        });
    }

    @Override
    @Nullable
    public Runnable updateFoldRegionsAsync(final @NotNull Editor editor, final boolean firstTime) {
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return null;
        }
        final Runnable runnable2 = this.updateFoldRegions(editor, firstTime, false);
        return new Runnable(){

            @Override
            public void run() {
                if (runnable2 != null) {
                    runnable2.run();
                }
                if (firstTime && !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                    CodeFoldingManagerImpl.this.initFolding(editor);
                }
            }
        };
    }

    @Nullable
    private Runnable updateFoldRegions(@NotNull Editor editor, boolean applyDefaultState, boolean quick) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        if (file2 != null) {
            return FoldingUpdate.updateFoldRegions(editor, file2, applyDefaultState, quick);
        }
        return null;
    }

    @Override
    public CodeFoldingState saveFoldingState(@NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(editor.getDocument());
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            info.loadFromEditor(editor);
        }
        return info;
    }

    @Override
    public void restoreFoldingState(@NotNull Editor editor, @NotNull CodeFoldingState state) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            state.setToEditor(editor);
        }
    }

    @Override
    public void writeFoldingState(@NotNull CodeFoldingState state, @NotNull Element element) throws WriteExternalException {
        if (!(state instanceof DocumentFoldingInfo)) {
            throw new WriteExternalException();
        }
        ((DocumentFoldingInfo)state).writeExternal(element);
    }

    @Override
    public CodeFoldingState readFoldingState(@NotNull Element element, @NotNull Document document) {
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(document);
        info.readExternal(element);
        return info;
    }

    @NotNull
    private DocumentFoldingInfo getDocumentFoldingInfo(@NotNull Document document) {
        DocumentFoldingInfo info = (DocumentFoldingInfo)document.getUserData(this.myFoldingInfoInDocumentKey);
        if (info == null) {
            info = new DocumentFoldingInfo(this.myProject, document);
            DocumentFoldingInfo written = (DocumentFoldingInfo)((UserDataHolderEx)document).putUserDataIfAbsent(this.myFoldingInfoInDocumentKey, (Object)info);
            if (written == info) {
                this.myDocumentsWithFoldingInfo.add(document);
            } else {
                info = written;
            }
        }
        return info;
    }

    static boolean isFoldingsInitializedInEditor(@NotNull Editor editor) {
        return Boolean.TRUE.equals(editor.getUserData(FOLDING_STATE_KEY));
    }
}

