/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VarargsSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiExpressionList;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        if (!(e instanceof PsiExpressionList)) {
            return Collections.emptyList();
        }
        PsiExpressionList expressionList = (PsiExpressionList)e;
        PsiParameterList parameterList = VarargsSelectioner.getParameterList(expressionList);
        if (parameterList == null) {
            return Collections.emptyList();
        }
        PsiExpression[] varargArgs = VarargsSelectioner.getVarargArgs(parameterList, expressionList);
        if (varargArgs.length == 0) {
            return Collections.emptyList();
        }
        TextRange firstExpressionRange = varargArgs[0].getTextRange();
        TextRange lastExpressionRange = varargArgs[varargArgs.length - 1].getTextRange();
        return Collections.singletonList(new TextRange(firstExpressionRange.getStartOffset(), lastExpressionRange.getEndOffset()));
    }

    @NotNull
    private static PsiExpression[] getVarargArgs(@NotNull PsiParameterList parameterList, @NotNull PsiExpressionList expressionList) {
        PsiParameter[] parameters = parameterList.getParameters();
        PsiExpression[] expressions = expressionList.getExpressions();
        if (parameters.length == 0 || expressions.length == 0) {
            return PsiExpression.EMPTY_ARRAY;
        }
        int varargIndex = parameters.length - 1;
        PsiParameter varargParam = parameters[varargIndex];
        if (!varargParam.isVarArgs() || parameters.length > expressions.length) {
            return PsiExpression.EMPTY_ARRAY;
        }
        return Arrays.copyOfRange(expressions, varargIndex, expressions.length);
    }

    @Nullable
    private static PsiParameterList getParameterList(@NotNull PsiExpressionList list) {
        if (!(list.getParent() instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethod method = ((PsiMethodCallExpression)list.getParent()).resolveMethod();
        return method != null ? method.getParameterList() : null;
    }
}

