/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;

public class MissingArrayInitializerBraceFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PsiArrayInitializerExpression)) {
            return;
        }
        PsiArrayInitializerExpression expr = (PsiArrayInitializerExpression)psiElement;
        if (!expr.getText().endsWith("}")) {
            PsiErrorElement err = (PsiErrorElement)ContainerUtil.findInstance((Object[])expr.getChildren(), PsiErrorElement.class);
            int endOffset = (err != null ? err : expr).getTextRange().getEndOffset();
            editor.getDocument().insertString(endOffset, (CharSequence)"}");
        }
    }
}

