/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;

public class IfConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof PsiIfStatement) {
            Document doc = editor.getDocument();
            PsiIfStatement ifStatement = (PsiIfStatement)psiElement;
            PsiJavaToken rParen = ifStatement.getRParenth();
            PsiJavaToken lParen = ifStatement.getLParenth();
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                if (lParen == null || rParen == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(ifStatement.getTextRange().getStartOffset()));
                    PsiStatement then2 = ifStatement.getThenBranch();
                    if (then2 != null) {
                        stopOffset = Math.min(stopOffset, then2.getTextRange().getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, ifStatement.getTextRange().getEndOffset());
                    doc.replaceString(ifStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"if ()");
                    processor2.registerUnresolvedError(ifStatement.getTextRange().getStartOffset() + "if (".length());
                } else {
                    processor2.registerUnresolvedError(lParen.getTextRange().getEndOffset());
                }
            } else if (rParen == null) {
                doc.insertString(condition.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }
}

