/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassLevelDeclarationStatement;
import com.intellij.psi.impl.source.jsp.jspJava.JspTemplateStatement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StatementMover
extends LineMover {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.actions.moveUpDown.StatementMover");
    private PsiElement statementToSurroundWithCodeBlock;

    StatementMover() {
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        super.beforeMove(editor, info, down);
        if (this.statementToSurroundWithCodeBlock != null) {
            this.surroundWithCodeBlock(info, down);
        }
    }

    private void surroundWithCodeBlock(@NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        try {
            Document document = PsiDocumentManager.getInstance((Project)this.statementToSurroundWithCodeBlock.getProject()).getDocument(this.statementToSurroundWithCodeBlock.getContainingFile());
            int startOffset = document.getLineStartOffset(info.toMove.startLine);
            int endOffset = StatementMover.getLineStartSafeOffset((Document)document, (int)info.toMove.endLine);
            if (document.getText().charAt(endOffset - 1) == '\n') {
                --endOffset;
            }
            RangeMarker lineRangeMarker = document.createRangeMarker(startOffset, endOffset);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.statementToSurroundWithCodeBlock.getProject()).getElementFactory();
            PsiCodeBlock codeBlock = factory.createCodeBlock();
            codeBlock.add(this.statementToSurroundWithCodeBlock);
            PsiBlockStatement blockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", this.statementToSurroundWithCodeBlock);
            blockStatement.getCodeBlock().replace((PsiElement)codeBlock);
            PsiBlockStatement newStatement = (PsiBlockStatement)this.statementToSurroundWithCodeBlock.replace((PsiElement)blockStatement);
            newStatement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(newStatement);
            info.toMove = new LineRange(document.getLineNumber(lineRangeMarker.getStartOffset()), document.getLineNumber(lineRangeMarker.getEndOffset()) + 1);
            PsiCodeBlock newCodeBlock = newStatement.getCodeBlock();
            if (down) {
                PsiElement blockChild = StatementMover.firstNonWhiteElement((PsiElement)newCodeBlock.getFirstBodyElement(), (boolean)true);
                if (blockChild == null) {
                    blockChild = newCodeBlock.getRBrace();
                }
                info.toMove2 = new LineRange(info.toMove2.startLine, document.getLineNumber(blockChild.getTextRange().getStartOffset()));
            } else {
                int end;
                int start = document.getLineNumber(newCodeBlock.getRBrace().getTextRange().getStartOffset());
                if (start > (end = info.toMove.startLine)) {
                    end = start;
                }
                info.toMove2 = new LineRange(start, end);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        int endOffset;
        boolean available = super.checkAvailable(editor, file2, info, down);
        if (!available) {
            return false;
        }
        LineRange range = info.toMove;
        if ((range = StatementMover.expandLineRangeToCoverPsiElements(range, editor, file2)) == null) {
            return false;
        }
        info.toMove = range;
        int startOffset = editor.logicalPositionToOffset(new LogicalPosition(range.startLine, 0));
        PsiElement[] statements = CodeInsightUtil.findStatementsInRange(file2, startOffset, endOffset = editor.logicalPositionToOffset(new LogicalPosition(range.endLine, 0)));
        if (statements.length == 0) {
            return false;
        }
        range.firstElement = statements[0];
        range.lastElement = statements[statements.length - 1];
        if (!this.checkMovingInsideOutside(file2, editor, info, down)) {
            info.toMove2 = null;
            return true;
        }
        return true;
    }

    private static int getDestLineForAnon(Editor editor, LineRange range, boolean down) {
        int destLine;
        int n = destLine = down ? range.endLine + 1 : range.startLine - 1;
        if (!(range.firstElement instanceof PsiStatement)) {
            return destLine;
        }
        PsiElement sibling = StatementUpDownMover.firstNonWhiteElement((PsiElement)(down ? range.lastElement.getNextSibling() : range.firstElement.getPrevSibling()), (boolean)down);
        PsiClass aClass = StatementMover.findChildOfType(sibling, PsiClass.class, PsiStatement.class);
        if (aClass != null && PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiStatement.class) == sibling) {
            destLine = editor.getDocument().getLineNumber(down ? sibling.getTextRange().getEndOffset() + 1 : sibling.getTextRange().getStartOffset());
        }
        return destLine;
    }

    @Nullable
    private static <T extends PsiElement> T findChildOfType(final @Nullable PsiElement element, final @NotNull Class<T> aClass, final @Nullable Class<? extends PsiElement> stopAt) {
        PsiElementProcessor.FindElement<PsiElement> processor2 = new PsiElementProcessor.FindElement<PsiElement>(){

            public boolean execute(@NotNull PsiElement each) {
                if (each == element) {
                    return true;
                }
                if (aClass.isInstance(each)) {
                    return this.setFound(each);
                }
                return stopAt == null || !stopAt.isInstance(each);
            }
        };
        PsiTreeUtil.processElements((PsiElement)element, (PsiElementProcessor)processor2);
        return (T)processor2.getFoundElement();
    }

    private boolean calcInsertOffset(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull LineRange range, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        int startLine;
        int destLine = StatementMover.getDestLineForAnon(editor, range, down);
        int n = startLine = down ? range.endLine : range.startLine - 1;
        if (destLine < 0 || startLine < 0) {
            return false;
        }
        do {
            int offset = editor.logicalPositionToOffset(new LogicalPosition(destLine, 0));
            for (PsiElement element = StatementMover.firstNonWhiteElement((int)offset, (PsiFile)file2, (boolean)true); element != null && !(element instanceof PsiFile); element = element.getParent()) {
                TextRange elementTextRange = element.getTextRange();
                if (!elementTextRange.isEmpty() && elementTextRange.grown(-1).shiftRight(1).contains(offset)) continue;
                PsiElement elementToSurround = null;
                boolean found = false;
                if ((element instanceof PsiStatement || element instanceof PsiComment) && StatementMover.statementCanBePlacedAlong(element)) {
                    found = true;
                    if (!(element.getParent() instanceof PsiCodeBlock)) {
                        elementToSurround = element;
                    }
                } else if (element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.RBRACE && element.getParent() instanceof PsiCodeBlock) {
                    found = true;
                }
                if (!found) continue;
                this.statementToSurroundWithCodeBlock = elementToSurround;
                info.toMove = range;
                int endLine = destLine;
                if (startLine > endLine) {
                    int tmp = endLine;
                    endLine = startLine;
                    startLine = tmp;
                }
                info.toMove2 = down ? new LineRange(startLine, endLine) : new LineRange(startLine, endLine + 1);
                return true;
            }
        } while ((destLine += down ? 1 : -1) != 0 && destLine < editor.getDocument().getLineCount());
        return false;
    }

    private static boolean statementCanBePlacedAlong(PsiElement element) {
        if (element instanceof JspTemplateStatement) {
            PsiElement neighbour = element.getPrevSibling();
            return neighbour != null && !(neighbour instanceof JspTemplateStatement);
        }
        if (element instanceof PsiBlockStatement) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JspClassLevelDeclarationStatement) {
            return false;
        }
        if (parent instanceof PsiCodeBlock) {
            return true;
        }
        if (parent instanceof PsiIfStatement && (element == ((PsiIfStatement)parent).getThenBranch() || element == ((PsiIfStatement)parent).getElseBranch())) {
            return true;
        }
        if (parent instanceof PsiWhileStatement && element == ((PsiWhileStatement)parent).getBody()) {
            return true;
        }
        return parent instanceof PsiDoWhileStatement && element == ((PsiDoWhileStatement)parent).getBody();
    }

    private boolean checkMovingInsideOutside(PsiFile file2, Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiElement elementAtInsertOffset;
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAtOffset = file2.getViewProvider().findElementAt(offset, StdLanguages.JAVA);
        if (elementAtOffset == null) {
            return false;
        }
        PsiElement guard = elementAtOffset;
        while ((guard = PsiTreeUtil.getParentOfType((PsiElement)guard, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiClass.class, PsiComment.class})) instanceof PsiAnonymousClass) {
        }
        PsiElement brace = StatementMover.itIsTheClosingCurlyBraceWeAreMoving(file2, editor);
        if (brace != null) {
            int line = editor.getDocument().getLineNumber(offset);
            LineRange toMove = new LineRange(line, line + 1);
            toMove.firstElement = toMove.lastElement = brace;
            info.toMove = toMove;
        }
        if (!this.calcInsertOffset(file2, editor, info.toMove, info, down)) {
            return false;
        }
        int insertOffset = down ? StatementMover.getLineStartSafeOffset((Document)editor.getDocument(), (int)info.toMove2.endLine) : editor.getDocument().getLineStartOffset(info.toMove2.startLine);
        PsiElement newGuard = elementAtInsertOffset = file2.getViewProvider().findElementAt(insertOffset, StdLanguages.JAVA);
        while ((newGuard = PsiTreeUtil.getParentOfType((PsiElement)newGuard, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiClass.class, PsiComment.class})) instanceof PsiAnonymousClass) {
        }
        if (brace != null && PsiTreeUtil.getParentOfType((PsiElement)brace, PsiCodeBlock.class, (boolean)false) != PsiTreeUtil.getParentOfType((PsiElement)elementAtInsertOffset, PsiCodeBlock.class, (boolean)false)) {
            info.indentSource = true;
        }
        if (newGuard == guard && StatementMover.isInside(insertOffset, newGuard) == StatementMover.isInside(offset, guard)) {
            return true;
        }
        if (guard instanceof PsiClass && guard.getParent() instanceof PsiClass) {
            return true;
        }
        return newGuard instanceof PsiClass && newGuard.getParent() instanceof PsiClass;
    }

    private static boolean isInside(int offset, PsiElement guard) {
        if (guard == null) {
            return false;
        }
        TextRange inside = guard instanceof PsiMethod ? ((PsiMethod)guard).getBody().getTextRange() : (guard instanceof PsiClassInitializer ? ((PsiClassInitializer)guard).getBody().getTextRange() : (guard instanceof PsiClass ? new TextRange(((PsiClass)guard).getLBrace().getTextOffset(), ((PsiClass)guard).getRBrace().getTextOffset()) : guard.getTextRange()));
        return inside != null && inside.contains(offset);
    }

    private static LineRange expandLineRangeToCoverPsiElements(LineRange range, Editor editor, PsiFile file2) {
        int endLine;
        Document document;
        Pair psiRange = StatementMover.getElementRange((Editor)editor, (PsiFile)file2, (LineRange)range);
        if (psiRange == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)((PsiElement)psiRange.getFirst()), (PsiElement)((PsiElement)psiRange.getSecond()));
        Pair elementRange = StatementMover.getElementRange((PsiElement)parent, (PsiElement)((PsiElement)psiRange.getFirst()), (PsiElement)((PsiElement)psiRange.getSecond()));
        if (elementRange == null) {
            return null;
        }
        int endOffset = ((PsiElement)elementRange.getSecond()).getTextRange().getEndOffset();
        if (endOffset > (document = editor.getDocument()).getTextLength()) {
            LOG.assertTrue(!PsiDocumentManager.getInstance((Project)file2.getProject()).isUncommited(document));
            LOG.assertTrue(PsiDocumentManagerImpl.checkConsistency(file2, document));
        }
        if (endOffset == document.getTextLength()) {
            endLine = document.getLineCount();
        } else {
            endLine = editor.offsetToLogicalPosition((int)endOffset).line + 1;
            endLine = Math.min(endLine, document.getLineCount());
        }
        int startLine = Math.min(range.startLine, editor.offsetToLogicalPosition((int)((PsiElement)elementRange.getFirst()).getTextOffset()).line);
        endLine = Math.max(endLine, range.endLine);
        return new LineRange(startLine, endLine);
    }

    private static PsiElement itIsTheClosingCurlyBraceWeAreMoving(PsiFile file2, Editor editor) {
        LineRange range = StatementMover.getLineRangeFromSelection((Editor)editor);
        if (range.endLine - range.startLine != 1) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int line = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(line);
        String lineText = document.getText().substring(lineStartOffset, document.getLineEndOffset(line));
        if (!lineText.trim().equals("}")) {
            return null;
        }
        return file2.findElementAt(lineStartOffset + lineText.indexOf(125));
    }
}

