/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.fillParagraph;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParagraphFillHandler {
    protected void performOnElement(final @NotNull PsiElement element, final @NotNull Editor editor) {
        final Document document = editor.getDocument();
        final TextRange textRange = this.getTextRange(element, editor);
        if (textRange.isEmpty()) {
            return;
        }
        String text = textRange.substring(element.getContainingFile().getText());
        List subStrings = StringUtil.split((String)text, (String)"\n", (boolean)true);
        String prefix = this.getPrefix(element);
        String postfix = this.getPostfix(element);
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPrefix(element, text, stringBuilder);
        for (String string : subStrings) {
            String startTrimmed = StringUtil.trimStart((String)string.trim(), (String)prefix.trim());
            String str = StringUtil.trimEnd((String)startTrimmed, (String)postfix.trim());
            String finalString = str.trim();
            if (StringUtil.isEmptyOrSpaces((String)finalString)) continue;
            stringBuilder.append(finalString).append(" ");
        }
        this.appendPostfix(element, text, stringBuilder);
        final String replacementText = stringBuilder.toString();
        CommandProcessor.getInstance().executeCommand(element.getProject(), new Runnable(){

            @Override
            public void run() {
                document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)replacementText);
                CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CodeStyleSettingsManager.getSettings((Project)element.getProject()), element.getLanguage());
                codeFormatter.doWrapLongLinesIfNecessary(editor, element.getProject(), document, textRange.getStartOffset(), textRange.getStartOffset() + replacementText.length() + 1);
            }
        }, null, (Object)document);
    }

    protected void appendPostfix(@NotNull PsiElement element, @NotNull String text, @NotNull StringBuilder stringBuilder) {
        String postfix = this.getPostfix(element);
        if (text.endsWith(postfix.trim())) {
            stringBuilder.append(postfix);
        }
    }

    protected void appendPrefix(@NotNull PsiElement element, @NotNull String text, @NotNull StringBuilder stringBuilder) {
        String prefix = this.getPrefix(element);
        if (text.startsWith(prefix.trim())) {
            stringBuilder.append(prefix);
        }
    }

    private TextRange getTextRange(@NotNull PsiElement element, @NotNull Editor editor) {
        int startOffset = this.getStartOffset(element, editor);
        int endOffset = this.getEndOffset(element, editor);
        return new UnfairTextRange(startOffset, endOffset);
    }

    private int getStartOffset(@NotNull PsiElement element, @NotNull Editor editor) {
        int lineNumber;
        if (this.isBunchOfElement(element)) {
            PsiElement firstElement = this.getFirstElement(element);
            return firstElement != null ? firstElement.getTextRange().getStartOffset() : element.getTextRange().getStartOffset();
        }
        int offset = editor.getCaretModel().getOffset();
        int elementTextOffset = element.getTextOffset();
        Document document = editor.getDocument();
        for (lineNumber = document.getLineNumber(offset); lineNumber != document.getLineNumber(elementTextOffset); --lineNumber) {
            String text = document.getText(TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber)));
            if (!StringUtil.isEmptyOrSpaces((String)text)) continue;
            ++lineNumber;
            break;
        }
        int lineStartOffset = lineNumber == document.getLineNumber(elementTextOffset) ? elementTextOffset : document.getLineStartOffset(lineNumber);
        String lineText = document.getText(TextRange.create((int)lineStartOffset, (int)document.getLineEndOffset(lineNumber)));
        int shift = StringUtil.findFirst((CharSequence)lineText, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        return lineStartOffset + shift;
    }

    protected boolean isBunchOfElement(PsiElement element) {
        return element instanceof PsiComment;
    }

    private int getEndOffset(@NotNull PsiElement element, @NotNull Editor editor) {
        int lineNumber;
        if (this.isBunchOfElement(element)) {
            PsiElement next = this.getLastElement(element);
            return next != null ? next.getTextRange().getEndOffset() : element.getTextRange().getEndOffset();
        }
        int offset = editor.getCaretModel().getOffset();
        int elementTextOffset = element.getTextRange().getEndOffset();
        Document document = editor.getDocument();
        for (lineNumber = document.getLineNumber(offset); lineNumber != document.getLineNumber(elementTextOffset); ++lineNumber) {
            String text = document.getText(TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber)));
            if (!StringUtil.isEmptyOrSpaces((String)text)) continue;
            --lineNumber;
            break;
        }
        return document.getLineEndOffset(lineNumber);
    }

    @Nullable
    private PsiElement getFirstElement(@NotNull PsiElement element) {
        IElementType elementType = element.getNode().getElementType();
        PsiElement result = element;
        for (PsiElement prevSibling = element.getPrevSibling(); prevSibling != null && (prevSibling.getNode().getElementType().equals(elementType) || this.atWhitespaceToken(prevSibling) && StringUtil.countChars((CharSequence)prevSibling.getText(), (char)'\n') <= 1); prevSibling = prevSibling.getPrevSibling()) {
            String text = prevSibling.getText();
            String prefix = this.getPrefix(element);
            String postfix = this.getPostfix(element);
            text = StringUtil.trimStart((String)text.trim(), (String)prefix.trim());
            text = StringUtil.trimEnd((String)text, (String)postfix);
            if (prevSibling.getNode().getElementType().equals(elementType) && StringUtil.isEmptyOrSpaces((String)text)) break;
            if (!prevSibling.getNode().getElementType().equals(elementType)) continue;
            result = prevSibling;
        }
        return result;
    }

    @Nullable
    private PsiElement getLastElement(@NotNull PsiElement element) {
        IElementType elementType = element.getNode().getElementType();
        PsiElement result = element;
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null && (nextSibling.getNode().getElementType().equals(elementType) || this.atWhitespaceToken(nextSibling) && StringUtil.countChars((CharSequence)nextSibling.getText(), (char)'\n') <= 1); nextSibling = nextSibling.getNextSibling()) {
            String text = nextSibling.getText();
            String prefix = this.getPrefix(element);
            String postfix = this.getPostfix(element);
            text = StringUtil.trimStart((String)text.trim(), (String)prefix.trim());
            text = StringUtil.trimEnd((String)text, (String)postfix);
            if (nextSibling.getNode().getElementType().equals(elementType) && StringUtil.isEmptyOrSpaces((String)text)) break;
            if (!nextSibling.getNode().getElementType().equals(elementType)) continue;
            result = nextSibling;
        }
        return result;
    }

    protected boolean atWhitespaceToken(@Nullable PsiElement element) {
        return element instanceof PsiWhiteSpace;
    }

    protected boolean isAvailableForElement(@Nullable PsiElement element) {
        return element != null;
    }

    protected boolean isAvailableForFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof PsiPlainTextFile;
    }

    @NotNull
    protected String getPrefix(@NotNull PsiElement element) {
        return "";
    }

    @NotNull
    protected String getPostfix(@NotNull PsiElement element) {
        return "";
    }
}

