/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandlerEP;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.NontrivialBraceMatcher;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageQuoteHandling;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedHandler
extends TypedActionHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.TypedHandler");
    private static final Map<FileType, QuoteHandler> quoteHandlers = new HashMap<FileType, QuoteHandler>();
    private static final Map<Class<? extends Language>, QuoteHandler> ourBaseLanguageQuoteHandlers = new HashMap<Class<? extends Language>, QuoteHandler>();

    public TypedHandler(TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    @Nullable
    public static QuoteHandler getQuoteHandler(@NotNull PsiFile file2, @NotNull Editor editor) {
        FileType fileFileType;
        FileType fileType = TypedHandler.getFileType(file2, editor);
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandlerForType(fileType);
        if (quoteHandler == null && (fileFileType = file2.getFileType()) != fileType) {
            quoteHandler = TypedHandler.getQuoteHandlerForType(fileFileType);
        }
        if (quoteHandler == null) {
            Language baseLanguage = file2.getViewProvider().getBaseLanguage();
            for (Map.Entry<Class<? extends Language>, QuoteHandler> entry : ourBaseLanguageQuoteHandlers.entrySet()) {
                if (!entry.getKey().isInstance(baseLanguage)) continue;
                return entry.getValue();
            }
            return (QuoteHandler)LanguageQuoteHandling.INSTANCE.forLanguage(baseLanguage);
        }
        return quoteHandler;
    }

    private static FileType getFileType(@NotNull PsiFile file2, @NotNull Editor editor) {
        LanguageFileType associatedFileType;
        FileType fileType = file2.getFileType();
        Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)file2.getProject());
        if (language != null && language != PlainTextLanguage.INSTANCE && (associatedFileType = language.getAssociatedFileType()) != null) {
            fileType = associatedFileType;
        }
        return fileType;
    }

    public static void registerBaseLanguageQuoteHandler(@NotNull Class<? extends Language> languageClass, @NotNull QuoteHandler quoteHandler) {
        ourBaseLanguageQuoteHandlers.put(languageClass, quoteHandler);
    }

    public static QuoteHandler getQuoteHandlerForType(@NotNull FileType fileType) {
        if (!quoteHandlers.containsKey(fileType)) {
            QuoteHandlerEP[] handlerEPs;
            QuoteHandler handler2 = null;
            for (QuoteHandlerEP ep : handlerEPs = (QuoteHandlerEP[])Extensions.getExtensions(QuoteHandlerEP.EP_NAME)) {
                if (!ep.fileType.equals(fileType.getName())) continue;
                handler2 = ep.getHandler();
                break;
            }
            quoteHandlers.put(fileType, handler2);
        }
        return quoteHandlers.get(fileType);
    }

    @Deprecated
    public static void registerQuoteHandler(@NotNull FileType fileType, @NotNull QuoteHandler quoteHandler) {
        quoteHandlers.put(fileType, quoteHandler);
    }

    public void execute(final @NotNull Editor originalEditor, final char charTyped, final @NotNull DataContext dataContext) {
        PsiFile originalFile;
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null || (originalFile = PsiUtilBase.getPsiFileInEditor((Editor)originalEditor, (Project)project2)) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
            }
            return;
        }
        if (!CodeInsightUtilBase.prepareEditorForWrite(originalEditor)) {
            return;
        }
        final PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        final Document originalDocument = originalEditor.getDocument();
        originalEditor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                Editor editor;
                if (psiDocumentManager.isDocumentBlockedByPsi(originalDocument)) {
                    psiDocumentManager.doPostponedOperationsAndUnblockDocument(originalDocument);
                }
                PsiFile file2 = (editor = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, originalEditor, originalFile)) == originalEditor ? originalFile : psiDocumentManager.getPsiFile(editor.getDocument());
                TypedHandlerDelegate[] delegates = (TypedHandlerDelegate[])Extensions.getExtensions((ExtensionPointName)TypedHandlerDelegate.EP_NAME);
                boolean handled = false;
                for (TypedHandlerDelegate delegate : delegates) {
                    TypedHandlerDelegate.Result result = delegate.checkAutoPopup(charTyped, project2, editor, file2);
                    boolean bl = handled = result == TypedHandlerDelegate.Result.STOP;
                    if (result != TypedHandlerDelegate.Result.CONTINUE) break;
                }
                if (!handled) {
                    TypedHandler.autoPopupCompletion(editor, charTyped, project2, file2);
                    TypedHandler.autoPopupParameterInfo(editor, charTyped, project2, file2);
                }
                if (!editor.isInsertMode()) {
                    TypedHandler.type(originalEditor, charTyped);
                    return;
                }
                EditorModificationUtil.deleteSelectedText((Editor)editor);
                FileType fileType = TypedHandler.getFileType(file2, editor);
                for (TypedHandlerDelegate delegate : delegates) {
                    TypedHandlerDelegate.Result result = delegate.beforeCharTyped(charTyped, project2, editor, file2, fileType);
                    if (result == TypedHandlerDelegate.Result.STOP) {
                        return;
                    }
                    if (result == TypedHandlerDelegate.Result.DEFAULT) break;
                }
                if (')' == charTyped || ']' == charTyped || '}' == charTyped ? FileTypes.PLAIN_TEXT != fileType && TypedHandler.handleRParen(editor, fileType, charTyped) : ('\"' == charTyped || '\'' == charTyped || '`' == charTyped) && TypedHandler.handleQuote(editor, charTyped, file2)) {
                    return;
                }
                long modificationStampBeforeTyping = editor.getDocument().getModificationStamp();
                TypedHandler.type(originalEditor, charTyped);
                AutoHardWrapHandler.getInstance().wrapLineIfNecessary(originalEditor, dataContext, modificationStampBeforeTyping);
                if (('(' == charTyped || '[' == charTyped || '{' == charTyped) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && fileType != FileTypes.PLAIN_TEXT) {
                    TypedHandler.handleAfterLParen(editor, fileType, charTyped);
                } else if ('}' == charTyped) {
                    TypedHandler.indentClosingBrace(project2, editor);
                } else if (')' == charTyped) {
                    TypedHandler.indentClosingParenth(project2, editor);
                }
                for (TypedHandlerDelegate delegate : delegates) {
                    TypedHandlerDelegate.Result result = delegate.charTyped(charTyped, project2, editor, file2);
                    if (result == TypedHandlerDelegate.Result.STOP) {
                        return;
                    }
                    if (result == TypedHandlerDelegate.Result.DEFAULT) break;
                }
                if ('{' == charTyped) {
                    TypedHandler.indentOpenedBrace(project2, editor);
                } else if ('(' == charTyped) {
                    TypedHandler.indentOpenedParenth(project2, editor);
                }
            }
        });
    }

    private static void type(Editor editor, char charTyped) {
        CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.in.editor.command.name", (Object[])new Object[0]));
        EditorModificationUtil.typeInStringAtCaretHonorBlockSelection((Editor)editor, (String)String.valueOf(charTyped), (boolean)true);
    }

    private static void autoPopupParameterInfo(@NotNull Editor editor, char charTyped, @NotNull Project project2, @NotNull PsiFile file2) {
        if (!(charTyped != '(' && charTyped != ',' || TypedHandler.isInsideStringLiteral(editor, file2))) {
            AutoPopupController.getInstance(project2).autoPopupParameterInfo(editor, null);
        }
    }

    public static void autoPopupCompletion(@NotNull Editor editor, char charTyped, @NotNull Project project2, @NotNull PsiFile file2) {
        if (charTyped == '.' || TypedHandler.isAutoPopup(editor, file2, charTyped)) {
            AutoPopupController.getInstance(project2).autoPopupMemberLookup(editor, null);
        }
    }

    public static void commitDocumentIfCurrentCaretIsNotTheFirstOne(@NotNull Editor editor, @NotNull Project project2) {
        if (ContainerUtil.getFirstItem((List)editor.getCaretModel().getAllCarets()) != editor.getCaretModel().getCurrentCaret()) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
        }
    }

    private static boolean isAutoPopup(@NotNull Editor editor, @NotNull PsiFile file2, char charTyped) {
        PsiElement element;
        int offset = editor.getCaretModel().getOffset() - 1;
        if (offset >= 0 && (element = file2.findElementAt(offset)) != null) {
            List list = CompletionContributor.forLanguage((Language)element.getLanguage());
            for (CompletionContributor contributor : list) {
                if (!contributor.invokeAutoPopup(element, charTyped)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInsideStringLiteral(@NotNull Editor editor, @NotNull PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return false;
        }
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
        if (definition != null) {
            ASTNode parentNode;
            TokenSet stringLiteralElements = definition.getStringLiteralElements();
            ASTNode node = element.getNode();
            if (node == null) {
                return false;
            }
            IElementType elementType = node.getElementType();
            if (stringLiteralElements.contains(elementType)) {
                return true;
            }
            PsiElement parent = element.getParent();
            if (parent != null && (parentNode = parent.getNode()) != null && stringLiteralElements.contains(parentNode.getElementType())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Editor injectedEditorIfCharTypedIsSignificant(char charTyped, @NotNull Editor editor, @NotNull PsiFile oldFile) {
        int offset = editor.getCaretModel().getOffset();
        for (DocumentWindow documentWindow : InjectedLanguageUtil.getCachedInjectedDocuments(oldFile)) {
            if (!documentWindow.isValid() || !documentWindow.containsRange(offset, offset)) continue;
            PsiFile injectedFile = PsiDocumentManager.getInstance((Project)oldFile.getProject()).getPsiFile((Document)documentWindow);
            Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
            CharSequence charsSequence = editor.getDocument().getCharsSequence();
            if (injectedEditor.getCaretModel().getOffset() == injectedEditor.getDocument().getTextLength() && offset < charsSequence.length() && charTyped == charsSequence.charAt(offset)) {
                return editor;
            }
            return injectedEditor;
        }
        return editor;
    }

    private static void handleAfterLParen(@NotNull Editor editor, @NotNull FileType fileType, char lparenChar) {
        boolean matched;
        int lparenOffset;
        boolean atEndOfDocument;
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        boolean bl = atEndOfDocument = offset == editor.getDocument().getTextLength();
        if (!atEndOfDocument) {
            iterator.retreat();
        }
        if (iterator.atEnd()) {
            return;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        if (iterator.atEnd()) {
            return;
        }
        IElementType braceTokenType = iterator.getTokenType();
        CharSequence fileText = editor.getDocument().getCharsSequence();
        if (!braceMatcher.isLBraceToken(iterator, fileText, fileType)) {
            return;
        }
        if (!iterator.atEnd()) {
            iterator.advance();
            if (!iterator.atEnd() && !BraceMatchingUtil.isPairedBracesAllowedBeforeTypeInFileType(braceTokenType, iterator.getTokenType(), fileType)) {
                return;
            }
            iterator.retreat();
        }
        if ((lparenOffset = BraceMatchingUtil.findLeftmostLParen(iterator, braceTokenType, fileText, fileType)) < 0) {
            lparenOffset = 0;
        }
        if (!(matched = BraceMatchingUtil.matchBrace(fileText, fileType, iterator = ((EditorEx)editor).getHighlighter().createIterator(lparenOffset), true, true))) {
            String text;
            if (lparenChar == '(') {
                text = ")";
            } else if (lparenChar == '[') {
                text = "]";
            } else if (lparenChar == '<') {
                text = ">";
            } else if (lparenChar == '{') {
                text = "}";
            } else {
                throw new AssertionError((Object)("Unknown char " + lparenChar));
            }
            editor.getDocument().insertString(offset, (CharSequence)text);
        }
    }

    public static boolean handleRParen(@NotNull Editor editor, @NotNull FileType fileType, char charTyped) {
        boolean matched;
        CharSequence text;
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getEnd() - iterator.getStart() != 1 || editor.getDocument().getCharsSequence().charAt(iterator.getStart()) != charTyped) {
            return false;
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        if (!braceMatcher.isRBraceToken(iterator, text = editor.getDocument().getCharsSequence(), fileType)) {
            return false;
        }
        IElementType tokenType = iterator.getTokenType();
        iterator.retreat();
        IElementType lparenTokenType = braceMatcher.getOppositeBraceTokenType(tokenType);
        int lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator, lparenTokenType, text, fileType);
        if (lparenthOffset < 0) {
            if (braceMatcher instanceof NontrivialBraceMatcher) {
                for (IElementType t : ((NontrivialBraceMatcher)braceMatcher).getOppositeBraceTokenTypes(tokenType)) {
                    if (t != lparenTokenType && (lparenthOffset = BraceMatchingUtil.findLeftmostLParen(iterator, t, text, fileType)) >= 0) break;
                }
            }
            if (lparenthOffset < 0) {
                return false;
            }
        }
        if (!(matched = BraceMatchingUtil.matchBrace(text, fileType, iterator = ((EditorEx)editor).getHighlighter().createIterator(lparenthOffset), true, true))) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    private static boolean handleQuote(@NotNull Editor editor, char quote, @NotNull PsiFile file2) {
        CharSequence closingQuote;
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return false;
        }
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor);
        if (quoteHandler == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        int length = document.getTextLength();
        if (TypedHandler.isTypingEscapeQuote(editor, quoteHandler, offset)) {
            return false;
        }
        if (offset < length && chars.charAt(offset) == quote && TypedHandler.isClosingQuote(editor, quoteHandler, offset)) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            return true;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (quoteHandler instanceof JavaLikeQuoteHandler) {
                try {
                    if (!((JavaLikeQuoteHandler)quoteHandler).isAppropriateElementTypeForLiteral(tokenType)) {
                        return false;
                    }
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
        }
        TypedHandler.type(editor, quote);
        offset = editor.getCaretModel().getOffset();
        if (quoteHandler instanceof MultiCharQuoteHandler && (closingQuote = TypedHandler.getClosingQuote(editor, (MultiCharQuoteHandler)quoteHandler, offset)) != null && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1) && (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset)))) {
            document.insertString(offset, closingQuote);
            return true;
        }
        if (TypedHandler.isOpeningQuote(editor, quoteHandler, offset - 1) && TypedHandler.hasNonClosedLiterals(editor, quoteHandler, offset - 1) && (offset == document.getTextLength() || !Character.isUnicodeIdentifierPart(document.getCharsSequence().charAt(offset)))) {
            document.insertString(offset, (CharSequence)String.valueOf(quote));
        }
        return true;
    }

    private static boolean isClosingQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isClosingQuote(iterator, offset);
    }

    @Nullable
    private static CharSequence getClosingQuote(@NotNull Editor editor, @NotNull MultiCharQuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            LOG.assertTrue(false);
            return null;
        }
        return quoteHandler.getClosingQuote(iterator, offset);
    }

    private static boolean isOpeningQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isOpeningQuote(iterator, offset);
    }

    private static boolean hasNonClosedLiterals(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.hasNonClosedLiteral(editor, iterator, offset);
    }

    private static boolean isTypingEscapeQuote(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        int offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\\");
        int slashCount = offset - 1 - offset1;
        return slashCount % 2 != 0 && TypedHandler.isInsideLiteral(editor, quoteHandler, offset);
    }

    private static boolean isInsideLiteral(@NotNull Editor editor, @NotNull QuoteHandler quoteHandler, int offset) {
        if (offset == 0) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
        if (iterator.atEnd()) {
            LOG.assertTrue(false);
            return false;
        }
        return quoteHandler.isInsideLiteral(iterator);
    }

    private static void indentClosingBrace(@NotNull Project project2, @NotNull Editor editor) {
        TypedHandler.indentBrace(project2, editor, '}');
    }

    static void indentOpenedBrace(@NotNull Project project2, @NotNull Editor editor) {
        TypedHandler.indentBrace(project2, editor, '{');
    }

    private static void indentOpenedParenth(@NotNull Project project2, @NotNull Editor editor) {
        TypedHandler.indentBrace(project2, editor, '(');
    }

    private static void indentClosingParenth(@NotNull Project project2, @NotNull Editor editor) {
        TypedHandler.indentBrace(project2, editor, ')');
    }

    private static void indentBrace(final @NotNull Project project2, final @NotNull Editor editor, char braceChar) {
        final int offset = editor.getCaretModel().getOffset() - 1;
        final Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset < 0 || chars.charAt(offset) != braceChar) {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            documentManager.commitDocument(document);
            final PsiFile file2 = documentManager.getPsiFile(document);
            if (file2 == null || !file2.isWritable()) {
                return;
            }
            PsiElement element = file2.findElementAt(offset);
            if (element == null) {
                return;
            }
            EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
            HighlighterIterator iterator = highlighter.createIterator(offset);
            FileType fileType = file2.getFileType();
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
            boolean rBraceToken = braceMatcher.isRBraceToken(iterator, chars, fileType);
            boolean isBrace = braceMatcher.isLBraceToken(iterator, chars, fileType) || rBraceToken;
            int lBraceOffset = -1;
            if (CodeInsightSettings.getInstance().REFORMAT_BLOCK_ON_RBRACE && rBraceToken && braceMatcher.isStructuralBrace(iterator, chars, fileType) && offset > 0) {
                lBraceOffset = BraceMatchingUtil.findLeftLParen(highlighter.createIterator(offset - 1), braceMatcher.getOppositeBraceTokenType(iterator.getTokenType()), editor.getDocument().getCharsSequence(), fileType);
            }
            if (element.getNode() != null && isBrace) {
                final int finalLBraceOffset = lBraceOffset;
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int newOffset;
                            if (finalLBraceOffset != -1) {
                                RangeMarker marker = document.createRangeMarker(offset, offset + 1);
                                CodeStyleManager.getInstance((Project)project2).reformatRange((PsiElement)file2, finalLBraceOffset, offset, true);
                                newOffset = marker.getStartOffset();
                                marker.dispose();
                            } else {
                                newOffset = CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, offset);
                            }
                            editor.getCaretModel().moveToOffset(newOffset + 1);
                            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            editor.getSelectionModel().removeSelection();
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }
    }
}

