/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBlockTransferable
implements Transferable {
    private final Collection<TextBlockTransferableData> myExtraData;
    private final RawText myRawText;
    private final String myText;
    private final DataFlavor[] myTransferDataFlavors;

    public TextBlockTransferable(@NotNull String text, @NotNull Collection<TextBlockTransferableData> extraData, @Nullable RawText rawText) {
        this.myText = TextBlockTransferable.cleanFromNullsIfNeeded(text);
        this.myExtraData = extraData;
        this.myRawText = rawText;
        ArrayList<DataFlavor> dataFlavors = new ArrayList<DataFlavor>();
        Collections.addAll(dataFlavors, DataFlavor.stringFlavor, DataFlavor.plainTextFlavor);
        DataFlavor flavor = RawText.getDataFlavor();
        if (this.myRawText != null && flavor != null) {
            dataFlavors.add(flavor);
        }
        for (TextBlockTransferableData data : extraData) {
            DataFlavor blockFlavor = data.getFlavor();
            if (blockFlavor == null) continue;
            dataFlavors.add(blockFlavor);
        }
        this.myTransferDataFlavors = dataFlavors.toArray(new DataFlavor[dataFlavors.size()]);
    }

    @NotNull
    private static String cleanFromNullsIfNeeded(@NotNull String text) {
        return SystemInfo.isMac ? text : text.replace('\u0000', ' ');
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.myTransferDataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors;
        for (DataFlavor flavor1 : flavors = this.getTransferDataFlavors()) {
            if (!flavor.equals(flavor1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        try {
            for (TextBlockTransferableData data : this.myExtraData) {
                if (!Comparing.equal((Object)data.getFlavor(), (Object)flavor)) continue;
                return data;
            }
            if (this.myRawText != null && Comparing.equal((Object)RawText.getDataFlavor(), (Object)flavor)) {
                return this.myRawText;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.myText;
            }
            if (DataFlavor.plainTextFlavor.equals(flavor)) {
                return new StringReader(this.myText);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull Editor editor, @NotNull String input) {
        return TextBlockTransferable.convertLineSeparators(editor, input, Collections.emptyList());
    }

    @NotNull
    public static String convertLineSeparators(@NotNull Editor editor, @NotNull String input, @NotNull Collection<TextBlockTransferableData> itemsToUpdate) {
        return TextBlockTransferable.convertLineSeparators(input, editor.isOneLineMode() ? " " : "\n", itemsToUpdate);
    }

    public static String convertLineSeparators(String text, String newSeparator, Collection<TextBlockTransferableData> itemsToUpdate) {
        if (itemsToUpdate.size() > 0) {
            int size = 0;
            for (TextBlockTransferableData data : itemsToUpdate) {
                size += data.getOffsetCount();
            }
            int[] offsets = new int[size];
            int index = 0;
            for (TextBlockTransferableData data : itemsToUpdate) {
                index = data.getOffsets(offsets, index);
            }
            text = StringUtil.convertLineSeparators((String)text, (String)newSeparator, (int[])offsets);
            index = 0;
            for (TextBlockTransferableData data : itemsToUpdate) {
                index = data.setOffsets(offsets, index);
            }
            return text;
        }
        return StringUtil.convertLineSeparators((String)text, (String)newSeparator);
    }
}

