/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Override
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        StringBuilder buffer = new StringBuilder();
        int givenTextOffset = 0;
        boolean textWasChanged = false;
        int deducedBlockSelectionWidth = StringLiteralCopyPasteProcessor.deduceBlockSelectionWidth(startOffsets, endOffsets, text);
        for (int i = 0; i < startOffsets.length && givenTextOffset < text.length(); ++i, ++givenTextOffset) {
            int givenTextEndOffset;
            if (i > 0) {
                buffer.append('\n');
            }
            int fileStartOffset = startOffsets[i];
            int fileEndOffset = endOffsets[i];
            int givenTextStartOffset = Math.min(givenTextOffset, text.length());
            givenTextOffset = givenTextEndOffset = Math.min(givenTextOffset + (fileEndOffset - fileStartOffset), text.length());
            PsiElement element = file2.findElementAt(fileStartOffset);
            while (givenTextStartOffset < givenTextEndOffset) {
                int escapedEndOffset;
                int escapedStartOffset;
                if (element == null) {
                    buffer.append(text.substring(givenTextStartOffset, givenTextEndOffset));
                    break;
                }
                TextRange elementRange = element.getTextRange();
                if ((this.isStringLiteral(element) || this.isCharLiteral(element)) && (elementRange.getStartOffset() < fileStartOffset || elementRange.getEndOffset() > fileEndOffset)) {
                    escapedStartOffset = elementRange.getStartOffset() + 1;
                    escapedEndOffset = elementRange.getEndOffset() - 1;
                } else {
                    escapedStartOffset = escapedEndOffset = elementRange.getStartOffset();
                }
                int numberOfSymbolsToCopy = escapedStartOffset - Math.max(fileStartOffset, elementRange.getStartOffset());
                if (numberOfSymbolsToCopy > 0) {
                    buffer.append(text.substring(givenTextStartOffset, givenTextStartOffset + numberOfSymbolsToCopy));
                    givenTextStartOffset += numberOfSymbolsToCopy;
                }
                if ((numberOfSymbolsToCopy = Math.min(escapedEndOffset, fileEndOffset) - Math.max(fileStartOffset, escapedStartOffset)) > 0) {
                    textWasChanged = true;
                    buffer.append(this.unescape(text.substring(givenTextStartOffset, givenTextStartOffset + numberOfSymbolsToCopy), element));
                    givenTextStartOffset += numberOfSymbolsToCopy;
                }
                if ((numberOfSymbolsToCopy = Math.min(fileEndOffset, elementRange.getEndOffset()) - Math.max(fileStartOffset, escapedEndOffset)) > 0) {
                    buffer.append(text.substring(givenTextStartOffset, givenTextStartOffset + numberOfSymbolsToCopy));
                    givenTextStartOffset += numberOfSymbolsToCopy;
                }
                element = PsiTreeUtil.nextLeaf((PsiElement)element);
            }
            int blockSelectionPadding = deducedBlockSelectionWidth - (fileEndOffset - fileStartOffset);
            for (int j = 0; j < blockSelectionPadding; ++j) {
                buffer.append(' ');
                ++givenTextOffset;
            }
        }
        return textWasChanged ? buffer.toString() : null;
    }

    private static int deduceBlockSelectionWidth(int[] startOffsets, int[] endOffsets, String text) {
        int fragmentCount = startOffsets.length;
        assert (fragmentCount > 0);
        int totalLength = fragmentCount - 1;
        for (int i = 0; i < fragmentCount; ++i) {
            totalLength += endOffsets[i] - startOffsets[i];
        }
        if (totalLength < text.length() && (text.length() + 1) % fragmentCount == 0) {
            return (text.length() + 1) / fragmentCount - 1;
        }
        return -1;
    }

    @NotNull
    protected String unescape(String text, PsiElement token) {
        return StringUtil.unescapeStringCharacters((String)text);
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project2, PsiFile file2, Editor editor, String text, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        PsiElement token = this.findLiteralTokenType(file2, selectionStart, selectionEnd);
        if (token == null) {
            return text;
        }
        if (this.isStringLiteral(token)) {
            StringBuilder buffer = new StringBuilder(text.length());
            String breaker = this.getLineBreaker(token);
            String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
            for (int i = 0; i < lines.length; ++i) {
                buffer.append(this.escapeCharCharacters(lines[i], token));
                if (i != lines.length - 1) {
                    buffer.append(breaker);
                    continue;
                }
                if (!text.endsWith("\n")) continue;
                buffer.append("\\n");
            }
            text = buffer.toString();
        } else if (this.isCharLiteral(token)) {
            return this.escapeCharCharacters(text, token);
        }
        return text;
    }

    protected String getLineBreaker(PsiElement token) {
        CommonCodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)token.getProject()).getCommonSettings(token.getLanguage());
        return codeStyleSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\\n\"\n+ \"" : "\\n\" +\n\"";
    }

    @Nullable
    protected PsiElement findLiteralTokenType(PsiFile file2, int selectionStart, int selectionEnd) {
        TextRange textRange;
        PsiElement elementAtSelectionStart = file2.findElementAt(selectionStart);
        if (elementAtSelectionStart == null) {
            return null;
        }
        if (!this.isStringLiteral(elementAtSelectionStart) && !this.isCharLiteral(elementAtSelectionStart)) {
            return null;
        }
        if (elementAtSelectionStart.getTextRange().getEndOffset() < selectionEnd) {
            PsiElement elementAtSelectionEnd = file2.findElementAt(selectionEnd);
            if (elementAtSelectionEnd == null) {
                return null;
            }
            if (elementAtSelectionEnd.getNode().getElementType() == elementAtSelectionStart.getNode().getElementType() && elementAtSelectionEnd.getTextRange().getStartOffset() < selectionEnd) {
                return elementAtSelectionStart;
            }
        }
        if (selectionStart <= (textRange = elementAtSelectionStart.getTextRange()).getStartOffset() || selectionEnd >= textRange.getEndOffset()) {
            return null;
        }
        return elementAtSelectionStart;
    }

    protected boolean isCharLiteral(@NotNull PsiElement token) {
        ASTNode node = token.getNode();
        return node != null && node.getElementType() == JavaTokenType.CHARACTER_LITERAL;
    }

    protected boolean isStringLiteral(@NotNull PsiElement token) {
        ASTNode node = token.getNode();
        return node != null && node.getElementType() == JavaTokenType.STRING_LITERAL;
    }

    @NotNull
    protected String escapeCharCharacters(@NotNull String s, @NotNull PsiElement token) {
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)(this.isStringLiteral(token) ? "\"" : "'"), (StringBuilder)buffer);
        return buffer.toString();
    }
}

