/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoinLinesHandler
extends EditorWriteActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.JoinLinesHandler");
    private final EditorActionHandler myOriginalHandler;

    public JoinLinesHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    @NotNull
    private static TextRange findStartAndEnd(@NotNull CharSequence text, int start, int end, int maxoffset) {
        while (start > 0 && (text.charAt(start) == ' ' || text.charAt(start) == '\t')) {
            --start;
        }
        while (end < maxoffset && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
            ++end;
        }
        return new TextRange(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWriteAction(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        assert (caret != null);
        if (!(editor.getDocument() instanceof DocumentEx)) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        DocumentEx doc = (DocumentEx)editor.getDocument();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
        if (project2 == null) {
            return;
        }
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = docManager.getPsiFile((Document)doc);
        if (psiFile == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        LogicalPosition caretPosition = caret.getLogicalPosition();
        int startLine = caretPosition.line;
        int endLine = startLine + 1;
        if (caret.hasSelection()) {
            startLine = doc.getLineNumber(caret.getSelectionStart());
            endLine = doc.getLineNumber(caret.getSelectionEnd());
            if (doc.getLineStartOffset(endLine) == caret.getSelectionEnd()) {
                --endLine;
            }
        }
        final int startReformatOffset = CharArrayUtil.shiftBackward((CharSequence)doc.getCharsSequence(), (int)doc.getLineEndOffset(startLine), (String)" \t");
        CodeEditUtil.setNodeReformatStrategy(new NotNullFunction<ASTNode, Boolean>(){

            @NotNull
            public Boolean fun(@NotNull ASTNode node) {
                return node.getTextRange().getStartOffset() >= startReformatOffset;
            }
        });
        try {
            JoinLinesHandler.doJob(editor, doc, caret, project2, docManager, psiFile, startLine, endLine);
        }
        finally {
            CodeEditUtil.setNodeReformatStrategy(null);
        }
    }

    private static void doJob(@NotNull Editor editor, @NotNull DocumentEx doc, @NotNull Caret caret, @NotNull Project project2, @NotNull PsiDocumentManager docManager, @NotNull PsiFile psiFile, int startLine, int endLine) {
        int caretRestoreOffset = -1;
        for (int i = startLine; i < endLine && i < doc.getLineCount() - 1; ++i) {
            JoinLinesHandlerDelegate delegate;
            int n;
            docManager.doPostponedOperationsAndUnblockDocument((Document)doc);
            docManager.commitDocument((Document)doc);
            CharSequence text = doc.getCharsSequence();
            JoinLinesOffsets offsets = JoinLinesHandler.calcJoinLinesOffsets(psiFile, doc, startLine);
            if (offsets.isStartLineEndsWithComment && !offsets.isNextLineStartsWithComment) {
                JoinLinesHandler.tryConvertEndOfLineComment(doc, offsets.elementAtStartLineEnd);
                offsets = JoinLinesHandler.calcJoinLinesOffsets(psiFile, doc, startLine);
            }
            int rc = -1;
            TextRange limits = JoinLinesHandler.findStartAndEnd(text, offsets.lastNonSpaceOffsetInStartLine, offsets.firstNonSpaceOffsetInNextLine, doc.getTextLength());
            int start = limits.getStartOffset();
            int end = limits.getEndOffset();
            JoinLinesHandlerDelegate[] joinLinesHandlerDelegateArray = (JoinLinesHandlerDelegate[])Extensions.getExtensions((ExtensionPointName)JoinLinesHandlerDelegate.EP_NAME);
            int n2 = joinLinesHandlerDelegateArray.length;
            for (n = 0; n < n2; ++n) {
                delegate = joinLinesHandlerDelegateArray[n];
                if (!(delegate instanceof JoinRawLinesHandlerDelegate) || (rc = ((JoinRawLinesHandlerDelegate)delegate).tryJoinRawLines((Document)doc, psiFile, start, end)) == -1) continue;
                caretRestoreOffset = rc;
                break;
            }
            if (rc == -1) {
                if (offsets.lastNonSpaceOffsetInStartLine == doc.getLineStartOffset(startLine)) {
                    doc.deleteString(doc.getLineStartOffset(startLine), offsets.firstNonSpaceOffsetInNextLine);
                    int indent = -1;
                    try {
                        docManager.commitDocument((Document)doc);
                        indent = CodeStyleManager.getInstance((Project)project2).adjustLineIndent(psiFile, startLine == 0 ? 0 : doc.getLineStartOffset(startLine));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                    if (caretRestoreOffset != -1) continue;
                    caretRestoreOffset = indent;
                    continue;
                }
                doc.deleteString(offsets.lineEndOffset, offsets.lineEndOffset + doc.getLineSeparatorLength(startLine));
                text = doc.getCharsSequence();
                limits = JoinLinesHandler.findStartAndEnd(text, offsets.lineEndOffset - 1, offsets.lineEndOffset, doc.getTextLength());
                start = limits.getStartOffset();
                end = limits.getEndOffset();
                docManager.commitDocument((Document)doc);
                JoinLinesHandlerDelegate[] indent = (JoinLinesHandlerDelegate[])Extensions.getExtensions((ExtensionPointName)JoinLinesHandlerDelegate.EP_NAME);
                int e = indent.length;
                for (n = 0; n < e && (rc = (delegate = indent[n]).tryJoinLines((Document)doc, psiFile, start, end)) == -1; ++n) {
                }
            }
            docManager.doPostponedOperationsAndUnblockDocument((Document)doc);
            if (rc != -1) {
                if (caretRestoreOffset != -1) continue;
                caretRestoreOffset = rc;
                continue;
            }
            if (caretRestoreOffset == -1) {
                int n3 = caretRestoreOffset = start == offsets.lineEndOffset ? start : start + 1;
            }
            if (offsets.isStartLineEndsWithComment && offsets.isNextLineStartsWithComment) {
                if (text.charAt(end) == '*' && end < text.length() && text.charAt(end + 1) != '/') {
                    ++end;
                    while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
                        ++end;
                    }
                } else if (text.charAt(end) == '/') {
                    end += 2;
                    while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
                        ++end;
                    }
                }
                doc.replaceString(start == offsets.lineEndOffset ? start : start + 1, end, " ");
                continue;
            }
            while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
                ++end;
            }
            doc.replaceString(start == offsets.lineEndOffset ? start : start + 1, end, " ");
            if (start <= doc.getLineStartOffset(startLine)) {
                try {
                    docManager.commitDocument((Document)doc);
                    CodeStyleManager.getInstance((Project)project2).adjustLineIndent(psiFile, doc.getLineStartOffset(startLine));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            int prevLineCount = doc.getLineCount();
            docManager.commitDocument((Document)doc);
            try {
                CodeStyleManager.getInstance((Project)project2).reformatRange((PsiElement)psiFile, start + 1, end, true);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            if (prevLineCount < doc.getLineCount()) {
                docManager.doPostponedOperationsAndUnblockDocument((Document)doc);
                start = end - doc.getLineSeparatorLength(startLine);
                int addedLinesCount = doc.getLineCount() - prevLineCount - 1;
                for (end = doc.getLineEndOffset(startLine) + doc.getLineSeparatorLength(startLine); end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t' || text.charAt(end) == '\n' && addedLinesCount > 0); ++end) {
                    if (text.charAt(end) != '\n') continue;
                    --addedLinesCount;
                }
                doc.replaceString(start, end, " ");
            }
            docManager.commitDocument((Document)doc);
        }
        docManager.commitDocument((Document)doc);
        if (caret.hasSelection()) {
            caret.moveToOffset(caret.getSelectionEnd());
        } else if (caretRestoreOffset != -1) {
            caret.moveToOffset(caretRestoreOffset);
            if (caret == editor.getCaretModel().getPrimaryCaret()) {
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
            caret.removeSelection();
        }
    }

    private static JoinLinesOffsets calcJoinLinesOffsets(PsiFile psiFile, Document doc, int startLine) {
        JoinLinesOffsets offsets = new JoinLinesOffsets();
        CharSequence text = doc.getCharsSequence();
        offsets.lineEndOffset = doc.getLineEndOffset(startLine);
        offsets.firstNonSpaceOffsetInNextLine = doc.getLineStartOffset(startLine + 1);
        while (offsets.firstNonSpaceOffsetInNextLine < text.length() - 1 && (text.charAt(offsets.firstNonSpaceOffsetInNextLine) == ' ' || text.charAt(offsets.firstNonSpaceOffsetInNextLine) == '\t')) {
            ++offsets.firstNonSpaceOffsetInNextLine;
        }
        PsiElement elementAtNextLineStart = psiFile.findElementAt(offsets.firstNonSpaceOffsetInNextLine);
        offsets.isNextLineStartsWithComment = JoinLinesHandler.isCommentElement(elementAtNextLineStart);
        offsets.lastNonSpaceOffsetInStartLine = offsets.lineEndOffset;
        while (offsets.lastNonSpaceOffsetInStartLine > 0 && (text.charAt(offsets.lastNonSpaceOffsetInStartLine - 1) == ' ' || text.charAt(offsets.lastNonSpaceOffsetInStartLine - 1) == '\t')) {
            --offsets.lastNonSpaceOffsetInStartLine;
        }
        int elemOffset = offsets.lastNonSpaceOffsetInStartLine > doc.getLineStartOffset(startLine) ? offsets.lastNonSpaceOffsetInStartLine - 1 : -1;
        offsets.elementAtStartLineEnd = elemOffset == -1 ? null : psiFile.findElementAt(elemOffset);
        offsets.isStartLineEndsWithComment = JoinLinesHandler.isCommentElement(offsets.elementAtStartLineEnd);
        return offsets;
    }

    private static void tryConvertEndOfLineComment(Document doc, PsiElement commentElement) {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(commentElement.getLanguage());
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter docCommenter = (CodeDocumentationAwareCommenter)commenter;
            String lineCommentPrefix = commenter.getLineCommentPrefix();
            String blockCommentPrefix = commenter.getBlockCommentPrefix();
            String blockCommentSuffix = commenter.getBlockCommentSuffix();
            if (commentElement.getNode().getElementType() == docCommenter.getLineCommentTokenType() && blockCommentPrefix != null && blockCommentSuffix != null && lineCommentPrefix != null) {
                String commentText = StringUtil.trimStart((String)commentElement.getText(), (String)lineCommentPrefix);
                try {
                    Project project2 = commentElement.getProject();
                    PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project2);
                    PsiComment newComment = parserFacade.createBlockCommentFromText(commentElement.getLanguage(), commentText);
                    commentElement.replace((PsiElement)newComment);
                    PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(doc);
                }
                catch (IncorrectOperationException e) {
                    LOG.info("Failed to replace line comment with block comment", (Throwable)e);
                }
            }
        }
    }

    private static boolean isCommentElement(@Nullable PsiElement element) {
        return element != null && PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null;
    }

    private static class JoinLinesOffsets {
        int lineEndOffset;
        int lastNonSpaceOffsetInStartLine;
        int firstNonSpaceOffsetInNextLine;
        boolean isStartLineEndsWithComment;
        boolean isNextLineStartsWithComment;
        PsiElement elementAtStartLineEnd;

        private JoinLinesOffsets() {
        }
    }
}

