/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;

public class CompletionAutoPopupHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler");
    public static volatile boolean ourTestingAutopopup = false;

    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project2, final Editor editor, PsiFile file2) {
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("checkAutoPopup: character=" + charTyped + ";");
            LOG.debug("phase=" + CompletionServiceImpl.getCompletionPhase());
            LOG.debug("lookup=" + lookup);
            LOG.debug("currentCompletion=" + CompletionServiceImpl.getCompletionService().getCurrentCompletion());
        }
        if (lookup != null) {
            if (editor.getSelectionModel().hasSelection()) {
                lookup.performGuardedChange(new Runnable(){

                    @Override
                    public void run() {
                        EditorModificationUtil.deleteSelectedText((Editor)editor);
                    }
                });
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        if (Character.isLetter(charTyped) || charTyped == '_') {
            AutoPopupController.getInstance(project2).scheduleAutoPopup(editor);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public static void invokeCompletion(@NotNull CompletionType completionType, boolean autopopup, Project project2, Editor editor, int time, boolean restart) {
        if (editor.isDisposed()) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            return;
        }
        Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(editor);
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(topLevelEditor.getDocument());
        if (file2 == null) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            return;
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        if (!PsiDocumentManager.getInstance((Project)project2).isCommitted(editor.getDocument())) {
            LOG.error("Non-committed document");
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        }
        Editor newEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(topLevelEditor, topLevelFile);
        try {
            new CodeCompletionHandlerBase(completionType, false, autopopup, false).invokeCompletion(project2, newEditor, time, false, restart);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public static void runLaterWithCommitted(final @NotNull Project project2, final @NotNull Document document, final @NotNull Runnable runnable2) {
        final long beforeStamp = document.getModificationStamp();
        PsiDocumentManager.getInstance((Project)project2).performWhenAllCommitted(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (beforeStamp != document.getModificationStamp()) {
                            CompletionAutoPopupHandler.runLaterWithCommitted(project2, document, runnable2);
                        } else {
                            runnable2.run();
                        }
                    }
                }, project2.getDisposed());
            }
        });
    }
}

