/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeDocumentationUtil {
    private CodeDocumentationUtil() {
    }

    public static String createDocCommentLine(String lineData, Project project2, CodeDocumentationAwareCommenter commenter) {
        if (!CodeStyleSettingsManager.getSettings((Project)project2).JD_LEADING_ASTERISKS_ARE_ENABLED) {
            return " " + lineData + " ";
        }
        if (lineData.length() == 0) {
            return commenter.getDocumentationCommentLinePrefix() + " ";
        }
        return commenter.getDocumentationCommentLinePrefix() + " " + lineData + " ";
    }

    @Nullable
    public static String getIndentInsideJavadoc(@NotNull Document document, int offset) {
        CharSequence text = document.getCharsSequence();
        if (offset >= text.length()) {
            return null;
        }
        int line = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        int i = CharArrayUtil.shiftForward((CharSequence)text, (int)lineStartOffset, (String)" \t");
        if (i > lineEndOffset || text.charAt(i) != '*') {
            return null;
        }
        int start = i + 1;
        int end = CharArrayUtil.shiftForward((CharSequence)text, (int)start, (String)" \t");
        return (end = Math.min(end, lineEndOffset)) > start ? text.subSequence(start, end).toString() : "";
    }

    @NotNull
    public static CommentContext tryParseCommentContext(@NotNull PsiFile file2, @NotNull CharSequence chars, int offset, int lineStartOffset) {
        Commenter langCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset));
        boolean isInsideCommentLikeCode = langCommenter instanceof CodeDocumentationAwareCommenter;
        if (!isInsideCommentLikeCode) {
            return new CommentContext();
        }
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)langCommenter;
        int commentStartOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (String)" \t");
        boolean docStart = commenter.getDocumentationCommentPrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)commentStartOffset, (CharSequence)commenter.getDocumentationCommentPrefix());
        boolean cStyleStart = commenter.getBlockCommentPrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)commentStartOffset, (CharSequence)commenter.getBlockCommentPrefix());
        boolean docAsterisk = commenter.getDocumentationCommentLinePrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)commentStartOffset, (CharSequence)commenter.getDocumentationCommentLinePrefix());
        int firstNonSpaceInLine = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        boolean slashSlash = commenter.getLineCommentPrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)commentStartOffset, (CharSequence)commenter.getLineCommentPrefix()) && firstNonSpaceInLine < chars.length() && chars.charAt(firstNonSpaceInLine) != '\n';
        return new CommentContext(commenter, docStart, cStyleStart, docAsterisk, slashSlash, commentStartOffset);
    }

    public static class CommentContext {
        public final CodeDocumentationAwareCommenter commenter;
        public final int lineStart;
        public boolean docStart;
        public boolean cStyleStart;
        public boolean docAsterisk;
        public boolean slashSlash;

        public CommentContext() {
            this.commenter = null;
            this.lineStart = 0;
        }

        public CommentContext(CodeDocumentationAwareCommenter commenter, boolean docStart, boolean cStyleStart, boolean docAsterisk, boolean slashSlash, int lineStart) {
            this.docStart = docStart;
            this.cStyleStart = cStyleStart;
            this.docAsterisk = docAsterisk;
            this.slashSlash = slashSlash;
            this.commenter = commenter;
            this.lineStart = lineStart;
        }
    }
}

