/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationPreviewPanelProvider
extends PreviewPanelProvider<Couple<PsiElement>, DocumentationComponent> {
    public static final PreviewProviderId<Couple<PsiElement>, DocumentationComponent> ID = PreviewProviderId.create("Documentation");
    private final DocumentationComponent myDocumentationComponent;
    private final DocumentationManager myDocumentationManager;

    public DocumentationPreviewPanelProvider(DocumentationManager documentationManager) {
        super(ID);
        this.myDocumentationManager = documentationManager;
        this.myDocumentationComponent = new DocumentationComponent(documentationManager){

            @Override
            public String toString() {
                return "Preview DocumentationComponent (" + (this.isEmpty() ? "empty" : "not empty") + ")";
            }
        };
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDocumentationComponent);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myDocumentationComponent;
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull Couple<PsiElement> content) {
        return DocumentationManager.getTitle((PsiElement)content.getFirst(), false);
    }

    @Override
    @Nullable
    protected Icon getIcon(@NotNull Couple<PsiElement> content) {
        return ((PsiElement)content.getFirst()).getIcon(0);
    }

    @Override
    public float getMenuOrder() {
        return 1.0f;
    }

    @Override
    public void showInStandardPlace(@NotNull Couple<PsiElement> content) {
        this.myDocumentationManager.showJavaDocInfo((PsiElement)content.getFirst(), (PsiElement)content.getSecond());
    }

    @Override
    public void release(@NotNull Couple<PsiElement> content) {
    }

    @Override
    public boolean contentsAreEqual(@NotNull Couple<PsiElement> content1, @NotNull Couple<PsiElement> content2) {
        return ((PsiElement)content1.getFirst()).getManager().areElementsEquivalent((PsiElement)content1.getFirst(), (PsiElement)content2.getFirst());
    }

    @Override
    public boolean isModified(Couple<PsiElement> content, boolean beforeReuse) {
        return beforeReuse;
    }

    @Override
    protected DocumentationComponent initComponent(Couple<PsiElement> content, boolean requestFocus) {
        if (!((PsiElement)content.getFirst()).getManager().areElementsEquivalent(this.myDocumentationComponent.getElement(), (PsiElement)content.getFirst())) {
            this.myDocumentationManager.fetchDocInfo((PsiElement)content.getFirst(), this.myDocumentationComponent);
        }
        return this.myDocumentationComponent;
    }
}

