/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateFieldOrPropertyHandler;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateFieldOrPropertyFix
implements IntentionAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.quickFix.CreateFieldOrPropertyFix");
    private final PsiClass myClass;
    private final String myName;
    private final PsiType myType;
    private final PropertyMemberType myMemberType;
    private final PsiAnnotation[] myAnnotations;

    public CreateFieldOrPropertyFix(PsiClass aClass, String name, PsiType type, @NotNull PropertyMemberType memberType, PsiAnnotation[] annotations) {
        this.myClass = aClass;
        this.myName = name;
        this.myType = type;
        this.myMemberType = memberType;
        this.myAnnotations = annotations;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message(this.myMemberType == PropertyMemberType.FIELD ? "create.field.text" : "create.property.text", this.myName);
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        this.applyFixInner(project2);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        this.applyFixInner(project2);
    }

    private void applyFixInner(final Project project2) {
        final PsiFile file2 = this.myClass.getContainingFile();
        final Editor editor = CodeInsightUtil.positionCursorAtLBrace(project2, this.myClass.getContainingFile(), this.myClass);
        if (editor != null) {
            new WriteCommandAction(project2, new PsiFile[]{file2}){

                protected void run(@NotNull Result result) throws Throwable {
                    CreateFieldOrPropertyFix.this.generateMembers(project2, editor, file2);
                }

                protected boolean isGlobalUndoAction() {
                    return true;
                }
            }.execute();
        }
    }

    private void generateMembers(Project project2, Editor editor, PsiFile file2) {
        try {
            List<? extends GenerationInfo> prototypes = new GenerateFieldOrPropertyHandler(this.myName, this.myType, this.myMemberType, this.myAnnotations).generateMemberPrototypes(this.myClass, ClassMember.EMPTY_ARRAY);
            prototypes = GenerateMembersUtil.insertMembersAtOffset(this.myClass.getContainingFile(), editor.getCaretModel().getOffset(), prototypes);
            if (prototypes.isEmpty()) {
                return;
            }
            PsiElement scope = prototypes.get(0).getPsiMember().getContext();
            assert (scope != null);
            EmptyExpression expression = new EmptyExpression(){

                @Override
                public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                    return new TextResult(CreateFieldOrPropertyFix.this.myType.getCanonicalText());
                }
            };
            TemplateBuilderImpl builder = new TemplateBuilderImpl(scope);
            boolean first = true;
            String TYPE_NAME_VAR = "TYPE_NAME_VAR";
            for (GenerationInfo generationInfo : prototypes) {
                PsiTypeElement typeElement = PropertyUtil.getPropertyTypeElement((PsiMember)generationInfo.getPsiMember());
                if (first) {
                    first = false;
                    builder.replaceElement((PsiElement)typeElement, "TYPE_NAME_VAR", (Expression)expression, true);
                    continue;
                }
                builder.replaceElement((PsiElement)typeElement, "TYPE_NAME_VAR", "TYPE_NAME_VAR", false);
            }
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            editor.getCaretModel().moveToOffset(scope.getTextRange().getStartOffset());
            TemplateManager.getInstance(project2).startTemplate(editor, builder.buildInlineTemplate());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

