/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapLongWithMathToIntExactFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    public static final MyMethodArgumentFixerFactory REGISTAR = new MyMethodArgumentFixerFactory();
    private final PsiType myType;

    public WrapLongWithMathToIntExactFix(PsiType type, @NotNull PsiExpression expression) {
        super((PsiElement)expression);
        this.myType = type;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        startElement.replace(WrapLongWithMathToIntExactFix.getModifiedExpression(startElement));
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return startElement.isValid() && startElement.getManager().isInProject(startElement) && PsiUtil.isLanguageLevel8OrHigher((PsiElement)startElement) && WrapLongWithMathToIntExactFix.areSameTypes(this.myType, PsiType.INT) && WrapLongWithMathToIntExactFix.areSameTypes(((PsiExpression)startElement).getType(), PsiType.LONG);
    }

    private static boolean areSameTypes(@Nullable PsiType type, @NotNull PsiPrimitiveType expected) {
        return type != null && type.isValid() && (type.equals(expected) || expected.getBoxedTypeName().equals(type.getCanonicalText(false)));
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("wrap.long.with.math.to.int.text", new Object[0]);
    }

    private static PsiElement getModifiedExpression(PsiElement expression) {
        return JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText("java.lang.Math.toIntExact(" + expression.getText() + ")", expression);
    }

    public static class MyMethodArgumentFixerFactory
    extends ArgumentFixerActionFactory {
        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            return WrapLongWithMathToIntExactFix.areSameTypes(toType, PsiType.INT) ? (PsiExpression)WrapLongWithMathToIntExactFix.getModifiedExpression((PsiElement)expression) : null;
        }

        @Override
        public boolean areTypesConvertible(PsiType exprType, PsiType parameterType, @NotNull PsiElement context) {
            return parameterType.isConvertibleFrom(exprType) || WrapLongWithMathToIntExactFix.areSameTypes(parameterType, PsiType.INT) && WrapLongWithMathToIntExactFix.areSameTypes(exprType, PsiType.LONG);
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new MyMethodArgumentFix(list, i, toType, this);
        }
    }

    private static class MyMethodArgumentFix
    extends MethodArgumentFix
    implements HighPriorityAction {
        protected MyMethodArgumentFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
            super(list, i, toType, fixerActionFactory);
        }

        @Nls
        @NotNull
        public String getText() {
            return this.myArgList.getExpressions().length == 1 ? QuickFixBundle.message("wrap.long.with.math.to.int.parameter.single.text", new Object[0]) : QuickFixBundle.message("wrap.long.with.math.to.int.parameter.multiple.text", this.myIndex + 1);
        }

        @Override
        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            return PsiUtil.isLanguageLevel8OrHigher((PsiElement)file2) && super.isAvailable(project2, editor, file2);
        }
    }
}

