/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VariableTypeFromCallFix
implements IntentionAction {
    private final PsiType myExpressionType;
    private final PsiVariable myVar;

    private VariableTypeFromCallFix(@NotNull PsiClassType type, @NotNull PsiVariable var) {
        this.myExpressionType = type;
        this.myVar = var;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("fix.variable.type.text", UsageViewUtil.getType((PsiElement)this.myVar), this.myVar.getName(), this.myExpressionType.getCanonicalText());
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.variable.type.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myExpressionType.isValid() && this.myVar.isValid();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        TypeMigrationRules rules = new TypeMigrationRules();
        rules.setBoundScope(PsiSearchHelper.SERVICE.getInstance((Project)project2).getUseScope((PsiElement)this.myVar));
        TypeMigrationProcessor.runHighlightingTypeMigration(project2, editor, rules, (PsiElement)this.myVar, this.myExpressionType);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public static List<IntentionAction> getQuickFixActions(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList list) {
        JavaResolveResult result = methodCall.getMethodExpression().advancedResolve(false);
        PsiMethod method = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions = list.getExpressions();
        if (method == null) {
            return Collections.emptyList();
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != expressions.length) {
            return Collections.emptyList();
        }
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        for (int i = 0; i < expressions.length; ++i) {
            PsiElement resolved;
            PsiParameter parameter;
            PsiType formalParamType;
            PsiType parameterType;
            PsiExpression expression = expressions[i];
            PsiType expressionType = expression.getType();
            if (expressionType instanceof PsiPrimitiveType) {
                expressionType = ((PsiPrimitiveType)expressionType).getBoxedType((PsiElement)expression);
            }
            if (expressionType == null || (parameterType = substitutor.substitute(formalParamType = (parameter = parameters[i]).getType())).isAssignableFrom(expressionType)) continue;
            PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
            if (qualifierExpression instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiVariable) {
                PsiType varType = ((PsiVariable)resolved).getType();
                PsiClass varClass = PsiUtil.resolveClassInType((PsiType)varType);
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
                if (varClass != null) {
                    PsiSubstitutor psiSubstitutor = resolveHelper.inferTypeArguments(varClass.getTypeParameters(), parameters, expressions, PsiSubstitutor.EMPTY, resolved, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                    PsiClassType appropriateVarType = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createType(varClass, psiSubstitutor);
                    if (varType.equals(appropriateVarType)) break;
                    actions.add(new VariableTypeFromCallFix(appropriateVarType, (PsiVariable)resolved));
                    break;
                }
            }
            actions.addAll(VariableTypeFromCallFix.getParameterTypeChangeFixes(method, expression, parameterType));
        }
        return actions;
    }

    private static List<IntentionAction> getParameterTypeChangeFixes(@NotNull PsiMethod method, @NotNull PsiExpression expression, PsiType parameterType) {
        if (!(expression instanceof PsiReferenceExpression)) {
            return Collections.emptyList();
        }
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        PsiManager manager = method.getManager();
        if (manager.isInProject((PsiElement)method)) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = method.findDeepestSuperMethods()) {
                if (manager.isInProject((PsiElement)superMethod)) continue;
                return Collections.emptyList();
            }
            PsiElement resolve = ((PsiReferenceExpression)expression).resolve();
            if (resolve instanceof PsiVariable) {
                result.addAll(HighlightUtil.getChangeVariableTypeFixes((PsiVariable)resolve, parameterType));
            }
        }
        return result;
    }
}

