/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VariableAccessFromInnerClassFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.VariableAccessFromInnerClassFix");
    private final PsiVariable myVariable;
    private final PsiElement myContext;
    private final int myFixType;
    private static final int MAKE_FINAL = 0;
    private static final int MAKE_ARRAY = 1;
    private static final int COPY_TO_FINAL = 2;
    private static final Key<Map<PsiVariable, Boolean>>[] VARS = new Key[]{Key.create((String)"VARS_TO_MAKE_FINAL"), Key.create((String)"VARS_TO_TRANSFORM"), Key.create((String)"???")};

    public VariableAccessFromInnerClassFix(@NotNull PsiVariable variable, @NotNull PsiElement element) {
        this.myVariable = variable;
        this.myContext = element;
        this.myFixType = VariableAccessFromInnerClassFix.getQuickFixType(variable);
        if (this.myFixType == -1) {
            return;
        }
        this.getVariablesToFix().add(variable);
    }

    @NotNull
    public String getText() {
        String message;
        switch (this.myFixType) {
            case 0: {
                message = "make.final.text";
                break;
            }
            case 1: {
                message = "make.final.transform.to.one.element.array";
                break;
            }
            case 2: {
                return QuickFixBundle.message("make.final.copy.to.temp", this.myVariable.getName(), (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myContext) ? "" : "effectively ") + "final");
            }
            default: {
                return "";
            }
        }
        Collection<PsiVariable> vars = this.getVariablesToFix();
        String varNames = vars.size() == 1 ? "'" + this.myVariable.getName() + "'" : "variables";
        return QuickFixBundle.message(message, varNames);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("make.final.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myContext.isValid() && this.myContext.getManager().isInProject(this.myContext) && this.myVariable.isValid() && this.myFixType != -1 && !this.getVariablesToFix().isEmpty() && !VariableAccessFromInnerClassFix.inOwnInitializer(this.myVariable, this.myContext);
    }

    private static boolean inOwnInitializer(PsiVariable variable, PsiElement context) {
        return PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)context, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{this.myContext, this.myVariable})) {
            return;
        }
        try {
            switch (this.myFixType) {
                case 0: {
                    this.makeFinal();
                    return;
                }
                case 1: {
                    this.makeArray();
                    return;
                }
                case 2: {
                    this.copyToFinal();
                    return;
                }
            }
            return;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        finally {
            this.getVariablesToFix().clear();
        }
    }

    private void makeArray() {
        for (PsiVariable var : this.getVariablesToFix()) {
            this.makeArray(var);
        }
    }

    @NotNull
    private Collection<PsiVariable> getVariablesToFix() {
        Map vars = (Map)this.myContext.getUserData(VARS[this.myFixType]);
        if (vars == null) {
            vars = ContainerUtil.createConcurrentWeakMap();
            this.myContext.putUserData(VARS[this.myFixType], (Object)vars);
        }
        final Map finalVars = vars;
        return new AbstractCollection<PsiVariable>(){

            @Override
            public boolean add(PsiVariable psiVariable) {
                return finalVars.put(psiVariable, Boolean.TRUE) == null;
            }

            @Override
            @NotNull
            public Iterator<PsiVariable> iterator() {
                return finalVars.keySet().iterator();
            }

            @Override
            public int size() {
                return finalVars.size();
            }
        };
    }

    private void makeFinal() {
        for (PsiVariable var : this.getVariablesToFix()) {
            if (!var.isValid()) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)true);
        }
    }

    private void makeArray(PsiVariable variable) throws IncorrectOperationException {
        PsiDeclarationStatement variableDeclarationStatement;
        variable.normalizeDeclaration();
        PsiType type = variable.getType();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myContext.getProject()).getElementFactory();
        PsiArrayType newType = type.createArrayType();
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            String expression = "[1]";
            while (type instanceof PsiArrayType) {
                expression = expression + "[1]";
                type = ((PsiArrayType)type).getComponentType();
            }
            PsiExpression init = factory.createExpressionFromText("new " + type.getCanonicalText() + expression, (PsiElement)variable);
            variableDeclarationStatement = factory.createVariableDeclarationStatement(variable.getName(), (PsiType)newType, init);
        } else {
            PsiExpression init = factory.createExpressionFromText("{ " + initializer.getText() + " }", (PsiElement)variable);
            variableDeclarationStatement = factory.createVariableDeclarationStatement(variable.getName(), (PsiType)newType, init);
        }
        PsiVariable newVariable = (PsiVariable)variableDeclarationStatement.getDeclaredElements()[0];
        PsiUtil.setModifierProperty((PsiModifierListOwner)newVariable, (String)"final", (boolean)true);
        PsiExpression newExpression = factory.createExpressionFromText(variable.getName() + "[0]", (PsiElement)variable);
        PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (outerCodeBlock == null) {
            return;
        }
        ArrayList<PsiReferenceExpression> outerReferences = new ArrayList<PsiReferenceExpression>();
        VariableAccessFromInnerClassFix.collectReferences(outerCodeBlock, variable, outerReferences);
        VariableAccessFromInnerClassFix.replaceReferences(outerReferences, (PsiElement)newExpression);
        variable.replace((PsiElement)newVariable);
    }

    private void copyToFinal() throws IncorrectOperationException {
        PsiManager psiManager = this.myContext.getManager();
        Project project2 = psiManager.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiExpression initializer = factory.createExpressionFromText(this.myVariable.getName(), this.myContext);
        String newName = VariableAccessFromInnerClassFix.suggestNewName(project2, this.myVariable);
        PsiType type = this.myVariable.getType();
        PsiDeclarationStatement copyDecl = factory.createVariableDeclarationStatement(newName, type, initializer);
        PsiVariable newVariable = (PsiVariable)copyDecl.getDeclaredElements()[0];
        boolean mustBeFinal = !PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myContext) || CodeStyleSettingsManager.getSettings((Project)project2).GENERATE_FINAL_LOCALS;
        PsiUtil.setModifierProperty((PsiModifierListOwner)newVariable, (String)"final", (boolean)mustBeFinal);
        PsiElement statement2 = this.getStatementToInsertBefore();
        if (statement2 == null) {
            return;
        }
        PsiExpression newExpression = factory.createExpressionFromText(newName, (PsiElement)this.myVariable);
        VariableAccessFromInnerClassFix.replaceReferences(this.myContext, this.myVariable, (PsiElement)newExpression);
        if (RefactoringUtil.isLoopOrIf(statement2.getParent())) {
            RefactoringUtil.putStatementInLoopBody((PsiStatement)copyDecl, statement2.getParent(), statement2);
        } else {
            statement2.getParent().addBefore((PsiElement)copyDecl, statement2);
        }
    }

    private PsiElement getStatementToInsertBefore() {
        PsiElement declarationScope;
        PsiElement psiElement = declarationScope = this.myVariable instanceof PsiParameter ? ((PsiParameter)this.myVariable).getDeclarationScope() : PsiUtil.getVariableCodeBlock((PsiVariable)this.myVariable, null);
        if (declarationScope == null) {
            return null;
        }
        PsiElement statement2 = this.myContext;
        block0: while (true) {
            if ((statement2 = RefactoringUtil.getParentStatement(statement2, false)) == null || statement2.getParent() == null) {
                return null;
            }
            for (PsiElement element = statement2; element != declarationScope && !(element instanceof PsiFile); element = element.getParent()) {
                if (!(element instanceof PsiClass)) continue;
                statement2 = statement2.getParent();
                continue block0;
            }
            break;
        }
        return statement2;
    }

    private static String suggestNewName(Project project2, PsiVariable variable) {
        String name = variable.getName();
        if (name.length() > 1 && Character.isDigit(name.charAt(name.length() - 1))) {
            name = name.substring(0, name.length() - 1);
        }
        name = "final" + StringUtil.capitalize((String)StringUtil.trimStart((String)name, (String)"final"));
        return JavaCodeStyleManager.getInstance((Project)project2).suggestUniqueVariableName(name, (PsiElement)variable, true);
    }

    private static void replaceReferences(PsiElement context, final PsiVariable variable, final PsiElement newExpression) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.resolve() == variable) {
                    try {
                        expression.replace(newExpression);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                super.visitReferenceExpression(expression);
            }
        });
    }

    private static void replaceReferences(List<PsiReferenceExpression> references, PsiElement newExpression) throws IncorrectOperationException {
        for (PsiReferenceExpression reference : references) {
            reference.replace(newExpression);
        }
    }

    private static void collectReferences(PsiElement context, final PsiVariable variable, final List<PsiReferenceExpression> references) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.resolve() == variable) {
                    references.add(expression);
                }
                super.visitReferenceExpression(expression);
            }
        });
    }

    private static int getQuickFixType(@NotNull PsiVariable variable) {
        PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (outerCodeBlock == null) {
            return -1;
        }
        ArrayList<PsiReferenceExpression> outerReferences = new ArrayList<PsiReferenceExpression>();
        VariableAccessFromInnerClassFix.collectReferences(outerCodeBlock, variable, outerReferences);
        int type = 0;
        for (PsiReferenceExpression expression : outerReferences) {
            PsiElement innerScope = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression);
            if (innerScope == null) continue;
            int thisType = 0;
            if (VariableAccessFromInnerClassFix.writtenInside(variable, innerScope)) {
                if (variable instanceof PsiParameter) {
                    return -1;
                }
                thisType = 1;
            }
            if (thisType == 0 && !VariableAccessFromInnerClassFix.canBeFinal(variable, outerReferences)) {
                thisType = 2;
            }
            type = Math.max(type, thisType);
        }
        return type;
    }

    private static boolean canBeFinal(@NotNull PsiVariable variable, @NotNull List<PsiReferenceExpression> references) {
        THashMap uninitializedVarProblems = new THashMap();
        THashMap finalVarProblems = new THashMap();
        for (PsiReferenceExpression expression : references) {
            if (ControlFlowUtil.isVariableAssignedInLoop(expression, (PsiElement)variable)) {
                return false;
            }
            HighlightInfo highlightInfo = HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(expression, variable, (Map<PsiElement, Collection<PsiReferenceExpression>>)uninitializedVarProblems, variable.getContainingFile());
            if (highlightInfo != null) {
                return false;
            }
            highlightInfo = HighlightControlFlowUtil.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable, expression, (Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>>)finalVarProblems);
            if (highlightInfo != null) {
                return false;
            }
            if (!(variable instanceof PsiParameter) || !PsiUtil.isAccessedForWriting((PsiExpression)expression)) continue;
            return false;
        }
        return true;
    }

    private static boolean writtenInside(PsiVariable variable, PsiElement element) {
        PsiElement[] children2;
        if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            if (lExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)lExpression).resolve() == variable) {
                return true;
            }
        } else if (PsiUtil.isIncrementDecrementOperation((PsiElement)element)) {
            PsiExpression operand;
            PsiExpression psiExpression = operand = element instanceof PsiPostfixExpression ? ((PsiPostfixExpression)element).getOperand() : ((PsiPrefixExpression)element).getOperand();
            if (operand instanceof PsiReferenceExpression && ((PsiReferenceExpression)operand).resolve() == variable) {
                return true;
            }
        }
        for (PsiElement child : children2 = element.getChildren()) {
            if (!VariableAccessFromInnerClassFix.writtenInside(variable, child)) continue;
            return true;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

