/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SurroundWithQuotesAnnotationParameterValueFix
implements IntentionAction {
    private final PsiAnnotationMemberValue myValue;
    private final PsiType myExpectedType;

    public SurroundWithQuotesAnnotationParameterValueFix(PsiAnnotationMemberValue value, PsiType expectedType) {
        this.myValue = value;
        this.myExpectedType = expectedType;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!(this.myValue.isValid() && this.myExpectedType.isValid() && this.myExpectedType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedType = ((PsiClassType)this.myExpectedType).resolve();
        return resolvedType != null && "java.lang.String".equals(resolvedType.getQualifiedName()) && this.myValue instanceof PsiLiteralExpression;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        String newText = this.myValue.getText();
        newText = StringUtil.stripQuotesAroundValue((String)newText);
        newText = "\"" + newText + "\"";
        PsiExpression newToken = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText(newText, null);
        PsiElement newElement = this.myValue.replace((PsiElement)newToken);
        editor.getCaretModel().moveToOffset(newElement.getTextOffset() + newElement.getTextLength());
    }

    @NotNull
    public String getFamilyName() {
        return "Surround annotation parameter value with quotes";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

