/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportConstantFix
extends StaticImportMemberFix<PsiField> {
    private final SmartPsiElementPointer<PsiJavaCodeReferenceElement> myRef;

    public StaticImportConstantFix(@NotNull PsiJavaCodeReferenceElement referenceElement) {
        this.myRef = SmartPointerManager.getInstance((Project)referenceElement.getProject()).createSmartPsiElementPointer((PsiElement)referenceElement);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        return "Static import constant";
    }

    @Override
    @NotNull
    protected String getMemberPresentableText(PsiField field) {
        return PsiFormatUtil.formatVariable((PsiVariable)field, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    @Override
    @NotNull
    protected List<PsiField> getMembersToImport(boolean applicableOnly) {
        String name;
        Project project2 = this.myRef.getProject();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project2);
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        String string = name = element != null ? element.getReferenceName() : null;
        if (name == null) {
            return Collections.emptyList();
        }
        StaticMembersProcessor<PsiField> processor2 = new StaticMembersProcessor<PsiField>((PsiElement)element){

            @Override
            protected boolean isApplicable(PsiField field, PsiElement place) {
                PsiType expectedType = this.getExpectedType();
                return expectedType == null || TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)field.getType());
            }
        };
        cache.processFieldsWithName(name, (Processor)processor2, element.getResolveScope(), null);
        return processor2.getMembersToImport(applicableOnly);
    }

    @NotNull
    protected StaticImportMethodQuestionAction<PsiField> createQuestionAction(List<PsiField> methodsToImport, @NotNull Project project2, Editor editor) {
        return new StaticImportMethodQuestionAction<PsiField>(project2, editor, methodsToImport, this.myRef){

            @Override
            @NotNull
            protected String getPopupTitle() {
                return QuickFixBundle.message("field.to.import.chooser.title", new Object[0]);
            }
        };
    }

    @Override
    @Nullable
    protected PsiElement getElement() {
        return this.myRef.getElement();
    }

    @Override
    @Nullable
    protected PsiElement getQualifierExpression() {
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        return element != null ? element.getQualifier() : null;
    }

    @Override
    @Nullable
    protected PsiElement resolveRef() {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.getElement();
        return referenceElement != null ? referenceElement.advancedResolve(true).getElement() : null;
    }
}

